@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDesktops.
 * @property desktopName
 * @property desktops
 * @property endUserIds
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property officeSiteId
 * @property outputFile
 * @property policyGroupId
 * @property status
 */
public data class GetDesktopsResult(
    public val desktopName: String? = null,
    public val desktops: List<GetDesktopsDesktop>,
    public val endUserIds: List<String>? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val officeSiteId: String? = null,
    public val outputFile: String? = null,
    public val policyGroupId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetDesktopsResult): GetDesktopsResult = GetDesktopsResult(
            desktopName = javaType.desktopName().map({ args0 -> args0 }).orElse(null),
            desktops = javaType.desktops().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetDesktopsDesktop.Companion.toKotlin(args0)
                })
            }),
            endUserIds = javaType.endUserIds().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            officeSiteId = javaType.officeSiteId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policyGroupId = javaType.policyGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
