@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the image.
 * @property dataDiskSize The size of data disk of the image.
 * @property description The description of the image.
 * @property gpuCategory The Gpu Category of the image.
 * @property id The ID of the Image.
 * @property imageId The image id of the image.
 * @property imageName The image name.
 * @property imageType The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
 * @property osType The os type of the image.
 * @property progress The progress of the image.
 * @property size The size of the image.
 * @property status The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
 */
public data class GetImagesImage(
    public val createTime: String,
    public val dataDiskSize: Int,
    public val description: String,
    public val gpuCategory: Boolean,
    public val id: String,
    public val imageId: String,
    public val imageName: String,
    public val imageType: String,
    public val osType: String,
    public val progress: String,
    public val size: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetImagesImage): GetImagesImage =
            GetImagesImage(
                createTime = javaType.createTime(),
                dataDiskSize = javaType.dataDiskSize(),
                description = javaType.description(),
                gpuCategory = javaType.gpuCategory(),
                id = javaType.id(),
                imageId = javaType.imageId(),
                imageName = javaType.imageName(),
                imageType = javaType.imageType(),
                osType = javaType.osType(),
                progress = javaType.progress(),
                size = javaType.size(),
                status = javaType.status(),
            )
    }
}
