@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getImages.
 * @property desktopInstanceType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property imageType
 * @property images
 * @property nameRegex
 * @property names
 * @property osType
 * @property outputFile
 * @property status
 */
public data class GetImagesResult(
    public val desktopInstanceType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val imageType: String? = null,
    public val images: List<GetImagesImage>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetImagesResult): GetImagesResult = GetImagesResult(
            desktopInstanceType = javaType.desktopInstanceType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            imageType = javaType.imageType().map({ args0 -> args0 }).orElse(null),
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetImagesImage.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
