@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capacity The capacity of nas file system.
 * @property createTime The create time of nas file system.
 * @property description The description of nas file system.
 * @property fileSystemId The filesystem id of nas file system.
 * @property fileSystemType The type of nas file system.
 * @property id The ID of the Nas File System.
 * @property meteredSize The size of metered.
 * @property mountTargetDomain The domain of mount target.
 * @property mountTargetStatus The status of mount target. Valid values: `Pending`, `Active`, `Inactive`,`Deleting`,`Invalid`.
 * @property nasFileSystemName The name of nas file system.
 * @property officeSiteId The ID of office site.
 * @property officeSiteName The name of office site.
 * @property status The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
 * @property storageType The storage type of nas file system.
 * @property supportAcl Whether to support Acl.
 * @property zoneId The zone id of nas file system.
 */
public data class GetNasFileSystemsSystem(
    public val capacity: String,
    public val createTime: String,
    public val description: String,
    public val fileSystemId: String,
    public val fileSystemType: String,
    public val id: String,
    public val meteredSize: String,
    public val mountTargetDomain: String,
    public val mountTargetStatus: String,
    public val nasFileSystemName: String,
    public val officeSiteId: String,
    public val officeSiteName: String,
    public val status: String,
    public val storageType: String,
    public val supportAcl: Boolean,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetNasFileSystemsSystem): GetNasFileSystemsSystem = GetNasFileSystemsSystem(
            capacity = javaType.capacity(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            fileSystemId = javaType.fileSystemId(),
            fileSystemType = javaType.fileSystemType(),
            id = javaType.id(),
            meteredSize = javaType.meteredSize(),
            mountTargetDomain = javaType.mountTargetDomain(),
            mountTargetStatus = javaType.mountTargetStatus(),
            nasFileSystemName = javaType.nasFileSystemName(),
            officeSiteId = javaType.officeSiteId(),
            officeSiteName = javaType.officeSiteName(),
            status = javaType.status(),
            storageType = javaType.storageType(),
            supportAcl = javaType.supportAcl(),
            zoneId = javaType.zoneId(),
        )
    }
}
