@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth The bandwidth of package.
 * @property createTime The creation time of network package.
 * @property eipAddresses The public IP address list of the network packet.
 * @property expiredTime The expired time of package.
 * @property id The ID of the Network Package.
 * @property internetChargeType The internet charge type  of  package.
 * @property networkPackageId The ID of network package.
 * @property officeSiteId The ID of office site.
 * @property officeSiteName The name of office site.
 * @property status The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
 */
public data class GetNetworkPackagesPackage(
    public val bandwidth: Int,
    public val createTime: String,
    public val eipAddresses: List<String>,
    public val expiredTime: String,
    public val id: String,
    public val internetChargeType: String,
    public val networkPackageId: String,
    public val officeSiteId: String,
    public val officeSiteName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetNetworkPackagesPackage): GetNetworkPackagesPackage = GetNetworkPackagesPackage(
            bandwidth = javaType.bandwidth(),
            createTime = javaType.createTime(),
            eipAddresses = javaType.eipAddresses().map({ args0 -> args0 }),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            networkPackageId = javaType.networkPackageId(),
            officeSiteId = javaType.officeSiteId(),
            officeSiteName = javaType.officeSiteName(),
            status = javaType.status(),
        )
    }
}
