@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNetworkPackages.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property packages
 * @property status
 */
public data class GetNetworkPackagesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val packages: List<GetNetworkPackagesPackage>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetNetworkPackagesResult): GetNetworkPackagesResult = GetNetworkPackagesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            packages = javaType.packages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetNetworkPackagesPackage.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
