@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorizeAccessPolicyRules The rule of authorize access rule.
 * @property authorizeSecurityPolicyRules The policy rule.
 * @property cameraRedirect Whether to enable local camera redirection. Valid values: `on`, `off`.
 * @property clipboard The clipboard policy.
 * @property domainList The list of domain.
 * @property edsCount The count of eds.
 * @property htmlAccess The access of html5.
 * @property htmlFileTransfer The html5 file transfer.
 * @property id The ID of the Policy Group.
 * @property localDrive Local drive redirect policy.
 * @property policyGroupId The policy group id.
 * @property policyGroupName The name of policy group.
 * @property policyGroupType The type of policy group.
 * @property recording Whether to enable screen recording. Valid values: `off`, `alltime`, `period`.
 * @property recordingEndTime The end time of recording.
 * @property recordingFps The fps of recording. Valid values: `2`, `5`, `10`, `15`.
 * @property recordingStartTime The start time of recording.
 * @property status The status of policy.
 * @property usbRedirect The usb redirect policy.
 * @property visualQuality The quality of visual.sae_ecdsae_nameecd_po
 * @property watermark The watermark policy.
 * @property watermarkTransparency The watermark transparency.
 * @property watermarkType The type of watemark.
 */
public data class GetPolicyGroupsGroup(
    public val authorizeAccessPolicyRules: List<GetPolicyGroupsGroupAuthorizeAccessPolicyRule>,
    public val authorizeSecurityPolicyRules: List<GetPolicyGroupsGroupAuthorizeSecurityPolicyRule>,
    public val cameraRedirect: String,
    public val clipboard: String,
    public val domainList: String,
    public val edsCount: Int,
    public val htmlAccess: String,
    public val htmlFileTransfer: String,
    public val id: String,
    public val localDrive: String,
    public val policyGroupId: String,
    public val policyGroupName: String,
    public val policyGroupType: String,
    public val recording: String,
    public val recordingEndTime: String,
    public val recordingFps: Int,
    public val recordingStartTime: String,
    public val status: String,
    public val usbRedirect: String,
    public val visualQuality: String,
    public val watermark: String,
    public val watermarkTransparency: String,
    public val watermarkType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetPolicyGroupsGroup): GetPolicyGroupsGroup = GetPolicyGroupsGroup(
            authorizeAccessPolicyRules = javaType.authorizeAccessPolicyRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetPolicyGroupsGroupAuthorizeAccessPolicyRule.Companion.toKotlin(args0)
                })
            }),
            authorizeSecurityPolicyRules = javaType.authorizeSecurityPolicyRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetPolicyGroupsGroupAuthorizeSecurityPolicyRule.Companion.toKotlin(args0)
                })
            }),
            cameraRedirect = javaType.cameraRedirect(),
            clipboard = javaType.clipboard(),
            domainList = javaType.domainList(),
            edsCount = javaType.edsCount(),
            htmlAccess = javaType.htmlAccess(),
            htmlFileTransfer = javaType.htmlFileTransfer(),
            id = javaType.id(),
            localDrive = javaType.localDrive(),
            policyGroupId = javaType.policyGroupId(),
            policyGroupName = javaType.policyGroupName(),
            policyGroupType = javaType.policyGroupType(),
            recording = javaType.recording(),
            recordingEndTime = javaType.recordingEndTime(),
            recordingFps = javaType.recordingFps(),
            recordingStartTime = javaType.recordingStartTime(),
            status = javaType.status(),
            usbRedirect = javaType.usbRedirect(),
            visualQuality = javaType.visualQuality(),
            watermark = javaType.watermark(),
            watermarkTransparency = javaType.watermarkTransparency(),
            watermarkType = javaType.watermarkType(),
        )
    }
}
