@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adConnectors The AD connectors.
 * @property createTime The CreateTime of resource.
 * @property customSecurityGroupId The id of the custom security group.
 * @property desktopAccessType The desktop access type.
 * @property desktopVpcEndpoint The desktop vpc endpoint.
 * @property directoryType The directory type.
 * @property dnsAddresses The address of DNSAddress.
 * @property dnsUserName The username of DNS.
 * @property domainName The name of the domain.
 * @property domainPassword The domain password.
 * @property domainUserName The username of the domain.
 * @property enableAdminAccess Whether to enable admin access.
 * @property enableCrossDesktopAccess Whether to enable cross desktop access.
 * @property enableInternetAccess Whether enable internet access.
 * @property fileSystemIds The ids of filesystem.
 * @property id The ID of the Ram Directory.
 * @property logs The register log information.
 * @property mfaEnabled Whether to enable MFA.
 * @property ramDirectoryId The ID of ram directory.
 * @property ramDirectoryName The name of directory.
 * @property ssoEnabled Whether to enable SSO.
 * @property status The status of directory.
 * @property subDnsAddresses The address of sub DNS.
 * @property subDomainName The Name of the sub-domain.
 * @property trustPassword The trust password.
 * @property vpcId The ID of the vpc.
 * @property vswitchIds List of vSwitch IDs in the directory.
 */
public data class GetRamDirectoriesDirectory(
    public val adConnectors: List<GetRamDirectoriesDirectoryAdConnector>,
    public val createTime: String,
    public val customSecurityGroupId: String,
    public val desktopAccessType: String,
    public val desktopVpcEndpoint: String,
    public val directoryType: String,
    public val dnsAddresses: List<String>,
    public val dnsUserName: String,
    public val domainName: String,
    public val domainPassword: String,
    public val domainUserName: String,
    public val enableAdminAccess: Boolean,
    public val enableCrossDesktopAccess: Boolean,
    public val enableInternetAccess: Boolean,
    public val fileSystemIds: List<String>,
    public val id: String,
    public val logs: List<GetRamDirectoriesDirectoryLog>,
    public val mfaEnabled: Boolean,
    public val ramDirectoryId: String,
    public val ramDirectoryName: String,
    public val ssoEnabled: Boolean,
    public val status: String,
    public val subDnsAddresses: List<String>,
    public val subDomainName: String,
    public val trustPassword: String,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetRamDirectoriesDirectory): GetRamDirectoriesDirectory = GetRamDirectoriesDirectory(
            adConnectors = javaType.adConnectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetRamDirectoriesDirectoryAdConnector.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            customSecurityGroupId = javaType.customSecurityGroupId(),
            desktopAccessType = javaType.desktopAccessType(),
            desktopVpcEndpoint = javaType.desktopVpcEndpoint(),
            directoryType = javaType.directoryType(),
            dnsAddresses = javaType.dnsAddresses().map({ args0 -> args0 }),
            dnsUserName = javaType.dnsUserName(),
            domainName = javaType.domainName(),
            domainPassword = javaType.domainPassword(),
            domainUserName = javaType.domainUserName(),
            enableAdminAccess = javaType.enableAdminAccess(),
            enableCrossDesktopAccess = javaType.enableCrossDesktopAccess(),
            enableInternetAccess = javaType.enableInternetAccess(),
            fileSystemIds = javaType.fileSystemIds().map({ args0 -> args0 }),
            id = javaType.id(),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eds.kotlin.outputs.GetRamDirectoriesDirectoryLog.Companion.toKotlin(args0)
                })
            }),
            mfaEnabled = javaType.mfaEnabled(),
            ramDirectoryId = javaType.ramDirectoryId(),
            ramDirectoryName = javaType.ramDirectoryName(),
            ssoEnabled = javaType.ssoEnabled(),
            status = javaType.status(),
            subDnsAddresses = javaType.subDnsAddresses().map({ args0 -> args0 }),
            subDomainName = javaType.subDomainName(),
            trustPassword = javaType.trustPassword(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
