@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adConnectorAddress The address of AD connector.
 * @property connectorStatus The status of connector.
 * @property networkInterfaceId The ID of the network interface.
 * @property vswitchId The ID of vSwitch.
 */
public data class GetRamDirectoriesDirectoryAdConnector(
    public val adConnectorAddress: String,
    public val connectorStatus: String,
    public val networkInterfaceId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetRamDirectoriesDirectoryAdConnector): GetRamDirectoriesDirectoryAdConnector = GetRamDirectoriesDirectoryAdConnector(
            adConnectorAddress = javaType.adConnectorAddress(),
            connectorStatus = javaType.connectorStatus(),
            networkInterfaceId = javaType.networkInterfaceId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
