@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new datasource alicloud_ecd_network_packages.
 * @property cenId Cloud Enterprise Network Instance Id.
 * @property cidrBlock Workspace Corresponds to the Security Office Network of IPv4 Segment.
 * @property createTime Workspace Creation Time.
 * @property customSecurityGroupId Security Group ID.
 * @property desktopAccessType Connect to the Cloud Desktop Allows the Use of the Access Mode of. Possible Values: the Internet: Only Allows the Client to Public Cloud Desktop. Virtual Private Cloud (VPC): Only Allows in the Virtual Private Cloud (VPC) in the Client to Connect to the Cloud Desktop. Any: Not by Way of Limitation. Use Client to Connect to the Cloud Desktop When It Is Possible to Choose the Connection.
 * @property desktopVpcEndpoint The Desktop Vpc Endpoint.
 * @property dnsAddresses Enterprise Ad Corresponding DNS Address.
 * @property dnsUserName Easy-to-Use DNS Name.
 * @property domainName Enterprise of Ad Domain Name.
 * @property domainPassword Domain of the User Who Will Administer This Target Application Password.
 * @property domainUserName The Domain Administrator's Username.
 * @property enableAdminAccess Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
 * @property enableCrossDesktopAccess Enable Cross-Desktop Access.
 * @property enableInternetAccess Whether the Open Internet Access Function.
 * @property fileSystemIds NAS File System ID.
 * @property id The ID of the Simple Office Site.
 * @property mfaEnabled Whether to Enable Multi-Factor Authentication MFA.
 * @property networkPackageId Internet Access ID.
 * @property officeSiteId The Workspace ID.
 * @property officeSiteType Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
 * @property simpleOfficeSiteName The simple office site name.
 * @property ssoEnabled Whether to Enable Single Sign-on (SSO) for User-Based SSO.
 * @property ssoStatus Whether to Enable Single Sign-on (SSO) for User-Based SSO.
 * @property status Workspace State. Possible Values: Registering: Registered in the Registered: Registered.
 * @property subDnsAddresses AD Subdomain of the DNS Address.
 * @property subDomainName AD Domain DNS Name.
 * @property trustPassword AD Trust Password.
 * @property vpcId Security Office VPC ID.
 * @property vswitchIds The vswitch ids.
 */
public data class GetSimpleOfficeSitesSite(
    @Deprecated(
        message = """
  Field 'bandwidth' has been deprecated from provider version 1.142.0.
  """,
    )
    public val bandwidth: Int,
    public val cenId: String,
    public val cidrBlock: String,
    public val createTime: String,
    public val customSecurityGroupId: String,
    public val desktopAccessType: String,
    public val desktopVpcEndpoint: String,
    public val dnsAddresses: List<String>,
    public val dnsUserName: String,
    public val domainName: String,
    public val domainPassword: String,
    public val domainUserName: String,
    public val enableAdminAccess: Boolean,
    public val enableCrossDesktopAccess: Boolean,
    @Deprecated(
        message = """
  Field 'enable_internet_access' has been deprecated from provider version 1.142.0.
  """,
    )
    public val enableInternetAccess: Boolean,
    public val fileSystemIds: List<String>,
    public val id: String,
    public val mfaEnabled: Boolean,
    public val networkPackageId: String,
    public val officeSiteId: String,
    public val officeSiteType: String,
    public val simpleOfficeSiteName: String,
    public val ssoEnabled: Boolean,
    public val ssoStatus: Boolean,
    public val status: String,
    public val subDnsAddresses: List<String>,
    public val subDomainName: String,
    public val trustPassword: String,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetSimpleOfficeSitesSite): GetSimpleOfficeSitesSite = GetSimpleOfficeSitesSite(
            bandwidth = javaType.bandwidth(),
            cenId = javaType.cenId(),
            cidrBlock = javaType.cidrBlock(),
            createTime = javaType.createTime(),
            customSecurityGroupId = javaType.customSecurityGroupId(),
            desktopAccessType = javaType.desktopAccessType(),
            desktopVpcEndpoint = javaType.desktopVpcEndpoint(),
            dnsAddresses = javaType.dnsAddresses().map({ args0 -> args0 }),
            dnsUserName = javaType.dnsUserName(),
            domainName = javaType.domainName(),
            domainPassword = javaType.domainPassword(),
            domainUserName = javaType.domainUserName(),
            enableAdminAccess = javaType.enableAdminAccess(),
            enableCrossDesktopAccess = javaType.enableCrossDesktopAccess(),
            enableInternetAccess = javaType.enableInternetAccess(),
            fileSystemIds = javaType.fileSystemIds().map({ args0 -> args0 }),
            id = javaType.id(),
            mfaEnabled = javaType.mfaEnabled(),
            networkPackageId = javaType.networkPackageId(),
            officeSiteId = javaType.officeSiteId(),
            officeSiteType = javaType.officeSiteType(),
            simpleOfficeSiteName = javaType.simpleOfficeSiteName(),
            ssoEnabled = javaType.ssoEnabled(),
            ssoStatus = javaType.ssoStatus(),
            status = javaType.status(),
            subDnsAddresses = javaType.subDnsAddresses().map({ args0 -> args0 }),
            subDomainName = javaType.subDomainName(),
            trustPassword = javaType.trustPassword(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
