@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the snapshot was created.
 * @property description The description of the snapshot.
 * @property desktopId The ID of the cloud desktop to which the snapshot belongs.
 * @property id The ID of the Snapshot.
 * @property progress The progress of creating the snapshot.
 * @property remainTime The remaining time that is required to create the snapshot. Unit: seconds.
 * @property snapshotId The ID of the snapshot.
 * @property snapshotName The name of the snapshot.
 * @property snapshotType The type of the snapshot.
 * @property sourceDiskSize The capacity of the source disk. Unit: GiB.
 * @property sourceDiskType The type of the source disk.
 * @property status The status of the snapshot.
 */
public data class GetSnapshotsSnapshot(
    public val createTime: String,
    public val description: String,
    public val desktopId: String,
    public val id: String,
    public val progress: String,
    public val remainTime: Int,
    public val snapshotId: String,
    public val snapshotName: String,
    public val snapshotType: String,
    public val sourceDiskSize: String,
    public val sourceDiskType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetSnapshotsSnapshot): GetSnapshotsSnapshot = GetSnapshotsSnapshot(
            createTime = javaType.createTime(),
            description = javaType.description(),
            desktopId = javaType.desktopId(),
            id = javaType.id(),
            progress = javaType.progress(),
            remainTime = javaType.remainTime(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            snapshotType = javaType.snapshotType(),
            sourceDiskSize = javaType.sourceDiskSize(),
            sourceDiskType = javaType.sourceDiskType(),
            status = javaType.status(),
        )
    }
}
