@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUsers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 * @property users
 */
public data class GetUsersResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val users: List<GetUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetUsersResult): GetUsersResult =
            GetUsersResult(
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                users = javaType.users().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eds.kotlin.outputs.GetUsersUser.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
