@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property email The email of the user email.
 * @property endUserId The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
 * @property id The ID of the user id.
 * @property phone The phone of the mobile phone number.
 * @property status The status of the resource.
 */
public data class GetUsersUser(
    public val email: String,
    public val endUserId: String,
    public val id: String,
    public val phone: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eds.outputs.GetUsersUser): GetUsersUser =
            GetUsersUser(
                email = javaType.email(),
                endUserId = javaType.endUserId(),
                id = javaType.id(),
                phone = javaType.phone(),
                status = javaType.status(),
            )
    }
}
