@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin

import com.pulumi.alicloud.eflo.EfloFunctions.getSubnetsPlain
import com.pulumi.alicloud.eflo.EfloFunctions.getVpdsPlain
import com.pulumi.alicloud.eflo.kotlin.inputs.GetSubnetsPlainArgs
import com.pulumi.alicloud.eflo.kotlin.inputs.GetSubnetsPlainArgsBuilder
import com.pulumi.alicloud.eflo.kotlin.inputs.GetVpdsPlainArgs
import com.pulumi.alicloud.eflo.kotlin.inputs.GetVpdsPlainArgsBuilder
import com.pulumi.alicloud.eflo.kotlin.outputs.GetSubnetsResult
import com.pulumi.alicloud.eflo.kotlin.outputs.GetVpdsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.eflo.kotlin.outputs.GetSubnetsResult.Companion.toKotlin as getSubnetsResultToKotlin
import com.pulumi.alicloud.eflo.kotlin.outputs.GetVpdsResult.Companion.toKotlin as getVpdsResultToKotlin

public object EfloFunctions {
    /**
     * This data source provides Eflo Subnet available to the user.[What is Subnet](https://help.aliyun.com/document_detail/604977.html)
     * > **NOTE:** Available in 1.204.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eflo.getSubnets({
     *     nameRegex: defaultAlicloudEfloSubnet.name,
     *     subnetName: "SubnetTestForTerraform",
     *     vpdId: vpdId,
     *     zoneId: zoneId,
     * });
     * export const alicloudEfloSubnetExampleId = _default.then(_default => _default.subnets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eflo.get_subnets(name_regex=default_alicloud_eflo_subnet["name"],
     *     subnet_name="SubnetTestForTerraform",
     *     vpd_id=vpd_id,
     *     zone_id=zone_id)
     * pulumi.export("alicloudEfloSubnetExampleId", default.subnets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eflo.GetSubnets.Invoke(new()
     *     {
     *         NameRegex = defaultAlicloudEfloSubnet.Name,
     *         SubnetName = "SubnetTestForTerraform",
     *         VpdId = vpdId,
     *         ZoneId = zoneId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEfloSubnetExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getSubnetsResult => getSubnetsResult&#46;Subnets[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := eflo.GetSubnets(ctx, &eflo.GetSubnetsArgs{
     * 			NameRegex:  pulumi.StringRef(defaultAlicloudEfloSubnet.Name),
     * 			SubnetName: pulumi.StringRef("SubnetTestForTerraform"),
     * 			VpdId:      pulumi.StringRef(vpdId),
     * 			ZoneId:     pulumi.StringRef(zoneId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudEfloSubnetExampleId", _default.Subnets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eflo.EfloFunctions;
     * import com.pulumi.alicloud.eflo.inputs.GetSubnetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EfloFunctions.getSubnets(GetSubnetsArgs.builder()
     *             .nameRegex(defaultAlicloudEfloSubnet.name())
     *             .subnetName("SubnetTestForTerraform")
     *             .vpdId(vpdId)
     *             .zoneId(zoneId)
     *             .build());
     *         ctx.export("alicloudEfloSubnetExampleId", default_.subnets()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eflo:getSubnets
     *       Arguments:
     *         nameRegex: ${defaultAlicloudEfloSubnet.name}
     *         subnetName: SubnetTestForTerraform
     *         vpdId: ${vpdId}
     *         zoneId: ${zoneId}
     * outputs:
     *   alicloudEfloSubnetExampleId: ${default.subnets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnets.
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: GetSubnetsPlainArgs): GetSubnetsResult =
        getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())

    /**
     * @see [getSubnets].
     * @param ids
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId Resource Group ID.
     * @param status The status of the resource.
     * @param subnetId Primary key ID.
     * @param subnetName The Subnet name.
     * @param type Eflo subnet usage type, optional value:
     * - General type is not filled in
     * - OOB:OOB type
     * - LB: LB type
     * @param vpdId The Eflo VPD ID.
     * @param zoneId The zone ID of the resource.
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        subnetId: String? = null,
        subnetName: String? = null,
        type: String? = null,
        vpdId: String? = null,
        zoneId: String? = null,
    ): GetSubnetsResult {
        val argument = GetSubnetsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
            subnetId = subnetId,
            subnetName = subnetName,
            type = type,
            vpdId = vpdId,
            zoneId = zoneId,
        )
        return getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eflo&#46;kotlin&#46;inputs&#46;GetSubnetsPlainArgs].
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: suspend GetSubnetsPlainArgsBuilder.() -> Unit): GetSubnetsResult {
        val builder = GetSubnetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetsResultToKotlin(getSubnetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Eflo Vpd available to the user.[What is Vpd](https://help.aliyun.com/document_detail/604976.html)
     * > **NOTE:** Available in 1.201.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eflo.getVpds({
     *     ids: [defaultAlicloudEfloVpd&#46;id],
     *     nameRegex: defaultAlicloudEfloVpd.name,
     *     vpdName: "RMC-Terraform-Test",
     * });
     * export const alicloudEfloVpdExampleId = _default.then(_default => _default.vpds?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eflo.get_vpds(ids=[default_alicloud_eflo_vpd["id"]],
     *     name_regex=default_alicloud_eflo_vpd["name"],
     *     vpd_name="RMC-Terraform-Test")
     * pulumi.export("alicloudEfloVpdExampleId", default.vpds[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eflo.GetVpds.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudEfloVpd.Id,
     *         },
     *         NameRegex = defaultAlicloudEfloVpd.Name,
     *         VpdName = "RMC-Terraform-Test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudEfloVpdExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getVpdsResult => getVpdsResult&#46;Vpds[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := eflo.GetVpds(ctx, &eflo.GetVpdsArgs{
     * Ids: interface{}{
     * defaultAlicloudEfloVpd.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudEfloVpd.Name),
     * VpdName: pulumi.StringRef("RMC-Terraform-Test"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudEfloVpdExampleId", _default.Vpds[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eflo.EfloFunctions;
     * import com.pulumi.alicloud.eflo.inputs.GetVpdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EfloFunctions.getVpds(GetVpdsArgs.builder()
     *             .ids(defaultAlicloudEfloVpd.id())
     *             .nameRegex(defaultAlicloudEfloVpd.name())
     *             .vpdName("RMC-Terraform-Test")
     *             .build());
     *         ctx.export("alicloudEfloVpdExampleId", default_.vpds()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eflo:getVpds
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudEfloVpd.id}
     *         nameRegex: ${defaultAlicloudEfloVpd.name}
     *         vpdName: RMC-Terraform-Test
     * outputs:
     *   alicloudEfloVpdExampleId: ${default.vpds[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpds.
     * @return A collection of values returned by getVpds.
     */
    public suspend fun getVpds(argument: GetVpdsPlainArgs): GetVpdsResult =
        getVpdsResultToKotlin(getVpdsPlain(argument.toJava()).await())

    /**
     * @see [getVpds].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Vpd IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The Resource group id
     * @param status The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
     * @param vpdId The id of the vpd.
     * @param vpdName The Name of the VPD.
     * @return A collection of values returned by getVpds.
     */
    public suspend fun getVpds(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        vpdId: String? = null,
        vpdName: String? = null,
    ): GetVpdsResult {
        val argument = GetVpdsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
            vpdId = vpdId,
            vpdName = vpdName,
        )
        return getVpdsResultToKotlin(getVpdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpds].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eflo&#46;kotlin&#46;inputs&#46;GetVpdsPlainArgs].
     * @return A collection of values returned by getVpds.
     */
    public suspend fun getVpds(argument: suspend GetVpdsPlainArgsBuilder.() -> Unit): GetVpdsResult {
        val builder = GetVpdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpdsResultToKotlin(getVpdsPlain(builtArgument.toJava()).await())
    }
}
