@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Subnet].
 */
@PulumiTagMarker
public class SubnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetArgs = SubnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetArgsBuilder.() -> Unit) {
        val builder = SubnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Subnet {
        val builtJavaResource = com.pulumi.alicloud.eflo.Subnet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subnet(builtJavaResource)
    }
}

/**
 * Provides a Eflo Subnet resource.
 * For information about Eflo Subnet and how to use it, see [What is Subnet](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).
 * > **NOTE:** Available since v1.204.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultVpd = new alicloud.eflo.Vpd("default", {
 *     cidr: "10.0.0.0/8",
 *     vpdName: name,
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[0]?.id),
 * });
 * const defaultSubnet = new alicloud.eflo.Subnet("default", {
 *     subnetName: name,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidr: "10.0.0.0/16",
 *     vpdId: defaultVpd.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_vpd = alicloud.eflo.Vpd("default",
 *     cidr="10.0.0.0/8",
 *     vpd_name=name,
 *     resource_group_id=default_get_resource_groups.groups[0].id)
 * default_subnet = alicloud.eflo.Subnet("default",
 *     subnet_name=name,
 *     zone_id=default.zones[0].id,
 *     cidr="10.0.0.0/16",
 *     vpd_id=default_vpd.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultVpd = new AliCloud.Eflo.Vpd("default", new()
 *     {
 *         Cidr = "10.0.0.0/8",
 *         VpdName = name,
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *     });
 *     var defaultSubnet = new AliCloud.Eflo.Subnet("default", new()
 *     {
 *         SubnetName = name,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Cidr = "10.0.0.0/16",
 *         VpdId = defaultVpd.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpd, err := eflo.NewVpd(ctx, "default", &eflo.VpdArgs{
 * 			Cidr:            pulumi.String("10.0.0.0/8"),
 * 			VpdName:         pulumi.String(name),
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eflo.NewSubnet(ctx, "default", &eflo.SubnetArgs{
 * 			SubnetName: pulumi.String(name),
 * 			ZoneId:     pulumi.String(_default.Zones[0].Id),
 * 			Cidr:       pulumi.String("10.0.0.0/16"),
 * 			VpdId:      defaultVpd.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.eflo.Vpd;
 * import com.pulumi.alicloud.eflo.VpdArgs;
 * import com.pulumi.alicloud.eflo.Subnet;
 * import com.pulumi.alicloud.eflo.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultVpd = new Vpd("defaultVpd", VpdArgs.builder()
 *             .cidr("10.0.0.0/8")
 *             .vpdName(name)
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .build());
 *         var defaultSubnet = new Subnet("defaultSubnet", SubnetArgs.builder()
 *             .subnetName(name)
 *             .zoneId(default_.zones()[0].id())
 *             .cidr("10.0.0.0/16")
 *             .vpdId(defaultVpd.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpd:
 *     type: alicloud:eflo:Vpd
 *     name: default
 *     properties:
 *       cidr: 10.0.0.0/8
 *       vpdName: ${name}
 *       resourceGroupId: ${defaultGetResourceGroups.groups[0].id}
 *   defaultSubnet:
 *     type: alicloud:eflo:Subnet
 *     name: default
 *     properties:
 *       subnetName: ${name}
 *       zoneId: ${default.zones[0].id}
 *       cidr: 10.0.0.0/16
 *       vpdId: ${defaultVpd.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments: {}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eflo Subnet can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eflo/subnet:Subnet example <vpd_id>:<subnet_id>
 * ```
 */
public class Subnet internal constructor(
    override val javaResource: com.pulumi.alicloud.eflo.Subnet,
) : KotlinCustomResource(javaResource, SubnetMapper) {
    /**
     * CIDR network segment.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Modification time.
     */
    public val gmtModified: Output<String>
        get() = javaResource.gmtModified().applyValue({ args0 -> args0 })

    /**
     * Error message.
     */
    public val message: Output<String>
        get() = javaResource.message().applyValue({ args0 -> args0 })

    /**
     * Resource Group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The id of the subnet.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * The Subnet name.
     */
    public val subnetName: Output<String>
        get() = javaResource.subnetName().applyValue({ args0 -> args0 })

    /**
     * Eflo subnet usage type. optional value:
     * - General type is not filled in
     * - OOB:OOB type
     * - LB: LB type
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Eflo VPD ID.
     */
    public val vpdId: Output<String>
        get() = javaResource.vpdId().applyValue({ args0 -> args0 })

    /**
     * The zone ID  of the resource.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object SubnetMapper : ResourceMapper<Subnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eflo.Subnet::class == javaResource::class

    override fun map(javaResource: Resource): Subnet = Subnet(
        javaResource as
            com.pulumi.alicloud.eflo.Subnet,
    )
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subnet].
 */
public suspend fun subnet(name: String, block: suspend SubnetResourceBuilder.() -> Unit): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnet(name: String): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
