@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin

import com.pulumi.alicloud.eflo.SubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Eflo Subnet resource.
 * For information about Eflo Subnet and how to use it, see [What is Subnet](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).
 * > **NOTE:** Available since v1.204.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultVpd = new alicloud.eflo.Vpd("default", {
 *     cidr: "10.0.0.0/8",
 *     vpdName: name,
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[0]?.id),
 * });
 * const defaultSubnet = new alicloud.eflo.Subnet("default", {
 *     subnetName: name,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidr: "10.0.0.0/16",
 *     vpdId: defaultVpd.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_vpd = alicloud.eflo.Vpd("default",
 *     cidr="10.0.0.0/8",
 *     vpd_name=name,
 *     resource_group_id=default_get_resource_groups.groups[0].id)
 * default_subnet = alicloud.eflo.Subnet("default",
 *     subnet_name=name,
 *     zone_id=default.zones[0].id,
 *     cidr="10.0.0.0/16",
 *     vpd_id=default_vpd.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultVpd = new AliCloud.Eflo.Vpd("default", new()
 *     {
 *         Cidr = "10.0.0.0/8",
 *         VpdName = name,
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *     });
 *     var defaultSubnet = new AliCloud.Eflo.Subnet("default", new()
 *     {
 *         SubnetName = name,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Cidr = "10.0.0.0/16",
 *         VpdId = defaultVpd.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpd, err := eflo.NewVpd(ctx, "default", &eflo.VpdArgs{
 * 			Cidr:            pulumi.String("10.0.0.0/8"),
 * 			VpdName:         pulumi.String(name),
 * 			ResourceGroupId: pulumi.String(defaultGetResourceGroups.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eflo.NewSubnet(ctx, "default", &eflo.SubnetArgs{
 * 			SubnetName: pulumi.String(name),
 * 			ZoneId:     pulumi.String(_default.Zones[0].Id),
 * 			Cidr:       pulumi.String("10.0.0.0/16"),
 * 			VpdId:      defaultVpd.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.eflo.Vpd;
 * import com.pulumi.alicloud.eflo.VpdArgs;
 * import com.pulumi.alicloud.eflo.Subnet;
 * import com.pulumi.alicloud.eflo.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultVpd = new Vpd("defaultVpd", VpdArgs.builder()
 *             .cidr("10.0.0.0/8")
 *             .vpdName(name)
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .build());
 *         var defaultSubnet = new Subnet("defaultSubnet", SubnetArgs.builder()
 *             .subnetName(name)
 *             .zoneId(default_.zones()[0].id())
 *             .cidr("10.0.0.0/16")
 *             .vpdId(defaultVpd.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpd:
 *     type: alicloud:eflo:Vpd
 *     name: default
 *     properties:
 *       cidr: 10.0.0.0/8
 *       vpdName: ${name}
 *       resourceGroupId: ${defaultGetResourceGroups.groups[0].id}
 *   defaultSubnet:
 *     type: alicloud:eflo:Subnet
 *     name: default
 *     properties:
 *       subnetName: ${name}
 *       zoneId: ${default.zones[0].id}
 *       cidr: 10.0.0.0/16
 *       vpdId: ${defaultVpd.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments: {}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eflo Subnet can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eflo/subnet:Subnet example <vpd_id>:<subnet_id>
 * ```
 * @property cidr CIDR network segment.
 * @property subnetName The Subnet name.
 * @property type Eflo subnet usage type. optional value:
 * - General type is not filled in
 * - OOB:OOB type
 * - LB: LB type
 * @property vpdId The Eflo VPD ID.
 * @property zoneId The zone ID  of the resource.
 */
public data class SubnetArgs(
    public val cidr: Output<String>? = null,
    public val subnetName: Output<String>? = null,
    public val type: Output<String>? = null,
    public val vpdId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eflo.SubnetArgs> {
    override fun toJava(): com.pulumi.alicloud.eflo.SubnetArgs =
        com.pulumi.alicloud.eflo.SubnetArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .subnetName(subnetName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpdId(vpdId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var subnetName: Output<String>? = null

    private var type: Output<String>? = null

    private var vpdId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value CIDR network segment.
     */
    @JvmName("jkntqxnbculcemkq")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The Subnet name.
     */
    @JvmName("ujsdsmpydsygujay")
    public suspend fun subnetName(`value`: Output<String>) {
        this.subnetName = value
    }

    /**
     * @param value Eflo subnet usage type. optional value:
     * - General type is not filled in
     * - OOB:OOB type
     * - LB: LB type
     */
    @JvmName("ubcdshyvoxwkpnpx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Eflo VPD ID.
     */
    @JvmName("ociacjoybsavubug")
    public suspend fun vpdId(`value`: Output<String>) {
        this.vpdId = value
    }

    /**
     * @param value The zone ID  of the resource.
     */
    @JvmName("rinsypuyojvarfbt")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value CIDR network segment.
     */
    @JvmName("jqbvksdmubiuwodb")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The Subnet name.
     */
    @JvmName("fjekjbnwhwbrucxv")
    public suspend fun subnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetName = mapped
    }

    /**
     * @param value Eflo subnet usage type. optional value:
     * - General type is not filled in
     * - OOB:OOB type
     * - LB: LB type
     */
    @JvmName("dijjcchsokswdwur")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The Eflo VPD ID.
     */
    @JvmName("tyihkxovucxgaxqm")
    public suspend fun vpdId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpdId = mapped
    }

    /**
     * @param value The zone ID  of the resource.
     */
    @JvmName("unkmtbbtessmxahn")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        cidr = cidr,
        subnetName = subnetName,
        type = type,
        vpdId = vpdId,
        zoneId = zoneId,
    )
}
