@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Vpd].
 */
@PulumiTagMarker
public class VpdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpdArgs = VpdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpdArgsBuilder.() -> Unit) {
        val builder = VpdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vpd {
        val builtJavaResource = com.pulumi.alicloud.eflo.Vpd(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vpd(builtJavaResource)
    }
}

/**
 * Provides a Eflo Vpd resource.
 * For information about Eflo Vpd and how to use it, see [What is Vpd](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultVpd = new alicloud.eflo.Vpd("default", {
 *     cidr: "10.0.0.0/8",
 *     vpdName: name,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_vpd = alicloud.eflo.Vpd("default",
 *     cidr="10.0.0.0/8",
 *     vpd_name=name,
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultVpd = new AliCloud.Eflo.Vpd("default", new()
 *     {
 *         Cidr = "10.0.0.0/8",
 *         VpdName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eflo.NewVpd(ctx, "default", &eflo.VpdArgs{
 * 			Cidr:            pulumi.String("10.0.0.0/8"),
 * 			VpdName:         pulumi.String(name),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.eflo.Vpd;
 * import com.pulumi.alicloud.eflo.VpdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultVpd = new Vpd("defaultVpd", VpdArgs.builder()
 *             .cidr("10.0.0.0/8")
 *             .vpdName(name)
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpd:
 *     type: alicloud:eflo:Vpd
 *     name: default
 *     properties:
 *       cidr: 10.0.0.0/8
 *       vpdName: ${name}
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eflo Vpd can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eflo/vpd:Vpd example <id>
 * ```
 */
public class Vpd internal constructor(
    override val javaResource: com.pulumi.alicloud.eflo.Vpd,
) : KotlinCustomResource(javaResource, VpdMapper) {
    /**
     * CIDR network segment.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Modification time
     */
    public val gmtModified: Output<String>
        get() = javaResource.gmtModified().applyValue({ args0 -> args0 })

    /**
     * The Resource group id.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Vpd status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The Name of the VPD.
     */
    public val vpdName: Output<String>
        get() = javaResource.vpdName().applyValue({ args0 -> args0 })
}

public object VpdMapper : ResourceMapper<Vpd> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eflo.Vpd::class == javaResource::class

    override fun map(javaResource: Resource): Vpd = Vpd(javaResource as com.pulumi.alicloud.eflo.Vpd)
}

/**
 * @see [Vpd].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vpd].
 */
public suspend fun vpd(name: String, block: suspend VpdResourceBuilder.() -> Unit): Vpd {
    val builder = VpdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vpd].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpd(name: String): Vpd {
    val builder = VpdResourceBuilder()
    builder.name(name)
    return builder.build()
}
