@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin

import com.pulumi.alicloud.eflo.VpdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Eflo Vpd resource.
 * For information about Eflo Vpd and how to use it, see [What is Vpd](https://www.alibabacloud.com/help/en/pai/user-guide/overview-of-intelligent-computing-lingjun).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultVpd = new alicloud.eflo.Vpd("default", {
 *     cidr: "10.0.0.0/8",
 *     vpdName: name,
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_vpd = alicloud.eflo.Vpd("default",
 *     cidr="10.0.0.0/8",
 *     vpd_name=name,
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultVpd = new AliCloud.Eflo.Vpd("default", new()
 *     {
 *         Cidr = "10.0.0.0/8",
 *         VpdName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eflo"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eflo.NewVpd(ctx, "default", &eflo.VpdArgs{
 * 			Cidr:            pulumi.String("10.0.0.0/8"),
 * 			VpdName:         pulumi.String(name),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.eflo.Vpd;
 * import com.pulumi.alicloud.eflo.VpdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultVpd = new Vpd("defaultVpd", VpdArgs.builder()
 *             .cidr("10.0.0.0/8")
 *             .vpdName(name)
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultVpd:
 *     type: alicloud:eflo:Vpd
 *     name: default
 *     properties:
 *       cidr: 10.0.0.0/8
 *       vpdName: ${name}
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eflo Vpd can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eflo/vpd:Vpd example <id>
 * ```
 * @property cidr CIDR network segment.
 * @property resourceGroupId The Resource group id.
 * @property vpdName The Name of the VPD.
 */
public data class VpdArgs(
    public val cidr: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val vpdName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eflo.VpdArgs> {
    override fun toJava(): com.pulumi.alicloud.eflo.VpdArgs =
        com.pulumi.alicloud.eflo.VpdArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .vpdName(vpdName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpdArgs].
 */
@PulumiTagMarker
public class VpdArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var vpdName: Output<String>? = null

    /**
     * @param value CIDR network segment.
     */
    @JvmName("vulklwolssdqgmpb")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The Resource group id.
     */
    @JvmName("lrwwihkqetftdawl")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Name of the VPD.
     */
    @JvmName("almlwcbjeppxudws")
    public suspend fun vpdName(`value`: Output<String>) {
        this.vpdName = value
    }

    /**
     * @param value CIDR network segment.
     */
    @JvmName("oanregbffnoeueuu")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The Resource group id.
     */
    @JvmName("satnroincehtruog")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Name of the VPD.
     */
    @JvmName("stepbjwevndxddrk")
    public suspend fun vpdName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpdName = mapped
    }

    internal fun build(): VpdArgs = VpdArgs(
        cidr = cidr,
        resourceGroupId = resourceGroupId,
        vpdName = vpdName,
    )
}
