@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.inputs

import com.pulumi.alicloud.eflo.inputs.GetSubnetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubnets.
 * @property ids
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId Resource Group ID.
 * @property status The status of the resource.
 * @property subnetId Primary key ID.
 * @property subnetName The Subnet name.
 * @property type Eflo subnet usage type, optional value:
 * - General type is not filled in
 * - OOB:OOB type
 * - LB: LB type
 * @property vpdId The Eflo VPD ID.
 * @property zoneId The zone ID of the resource.
 */
public data class GetSubnetsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val subnetId: String? = null,
    public val subnetName: String? = null,
    public val type: String? = null,
    public val vpdId: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eflo.inputs.GetSubnetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eflo.inputs.GetSubnetsPlainArgs =
        com.pulumi.alicloud.eflo.inputs.GetSubnetsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .subnetId(subnetId?.let({ args0 -> args0 }))
            .subnetName(subnetName?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .vpdId(vpdId?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubnetsPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var subnetId: String? = null

    private var subnetName: String? = null

    private var type: String? = null

    private var vpdId: String? = null

    private var zoneId: String? = null

    /**
     * @param value
     */
    @JvmName("dedvyxnvvfbulcwe")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("anphiysnxtgelybi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("tupchqtsrvymdsmi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jvwpvoxodakjcyso")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("tblnfroftxknueiw")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("nepctjiuvdufqxnt")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Resource Group ID.
     */
    @JvmName("nmclscugcmnuwjhx")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("egirqpfxokwjgndt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Primary key ID.
     */
    @JvmName("fatwivtulfficqxp")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subnetId = mapped
    }

    /**
     * @param value The Subnet name.
     */
    @JvmName("gadhsomeqsrmuifo")
    public suspend fun subnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subnetName = mapped
    }

    /**
     * @param value Eflo subnet usage type, optional value:
     * - General type is not filled in
     * - OOB:OOB type
     * - LB: LB type
     */
    @JvmName("ganimnnpcbgisyha")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value The Eflo VPD ID.
     */
    @JvmName("gxxylueniypnepin")
    public suspend fun vpdId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpdId = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("cwfnwseoyisvetuj")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetSubnetsPlainArgs = GetSubnetsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        status = status,
        subnetId = subnetId,
        subnetName = subnetName,
        type = type,
        vpdId = vpdId,
        zoneId = zoneId,
    )
}
