@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.inputs

import com.pulumi.alicloud.eflo.inputs.GetVpdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpds.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Vpd IDs.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The Resource group id
 * @property status The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
 * @property vpdId The id of the vpd.
 * @property vpdName The Name of the VPD.
 */
public data class GetVpdsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val vpdId: String? = null,
    public val vpdName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eflo.inputs.GetVpdsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eflo.inputs.GetVpdsPlainArgs =
        com.pulumi.alicloud.eflo.inputs.GetVpdsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpdId(vpdId?.let({ args0 -> args0 }))
            .vpdName(vpdName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpdsPlainArgs].
 */
@PulumiTagMarker
public class GetVpdsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var vpdId: String? = null

    private var vpdName: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("jkvmrtqskgmjkrcs")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Vpd IDs.
     */
    @JvmName("mvueqmwxkmorkykf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpd IDs.
     */
    @JvmName("qmkvycgdunrmedci")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("lwndafdavuoyyldt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gchfxumdstwkjrkg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("djdtmivxrgwulqsw")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("acqcqbpdqcxxtksl")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Resource group id
     */
    @JvmName("diqvoixsownfbxak")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
     */
    @JvmName("nxqeuellmyfohfcg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The id of the vpd.
     */
    @JvmName("qgrrpwhcxiwufwob")
    public suspend fun vpdId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpdId = mapped
    }

    /**
     * @param value The Name of the VPD.
     */
    @JvmName("vqokbceytnirlutw")
    public suspend fun vpdName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpdName = mapped
    }

    internal fun build(): GetVpdsPlainArgs = GetVpdsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        status = status,
        vpdId = vpdId,
        vpdName = vpdName,
    )
}
