@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSubnets.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of name of Subnets.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId Resource Group ID.
 * @property status The status of the resource.
 * @property subnetId The Eflo subnet ID.
 * @property subnetName The Subnet name.
 * @property subnets A list of Subnet Entries. Each element contains the following attributes:
 * @property type Eflo subnet usage type.
 * @property vpdId Eflo VPD ID.
 * @property zoneId The zone ID of the resource.
 */
public data class GetSubnetsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val subnetId: String? = null,
    public val subnetName: String? = null,
    public val subnets: List<GetSubnetsSubnet>,
    public val type: String? = null,
    public val vpdId: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eflo.outputs.GetSubnetsResult): GetSubnetsResult = GetSubnetsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            subnetName = javaType.subnetName().map({ args0 -> args0 }).orElse(null),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eflo.kotlin.outputs.GetSubnetsSubnet.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            vpdId = javaType.vpdId().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
