@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidr Network segment
 * @property createTime The creation time of the resource
 * @property gmtModified Modification time
 * @property id The ID of the resource.
 * @property message Error message
 * @property resourceGroupId Resource Group ID.
 * @property status The status of the resource.
 * @property subnetId Primary key ID.
 * @property subnetName The Subnet name.
 * @property type Eflo subnet usage type, optional value:
 * - General type is not filled in
 * - OOB:OOB type
 * - LB: LB type
 * @property vpdId The Eflo VPD ID.
 * @property zoneId The zone ID of the resource.
 */
public data class GetSubnetsSubnet(
    public val cidr: String,
    public val createTime: String,
    public val gmtModified: String,
    public val id: String,
    public val message: String,
    public val resourceGroupId: String,
    public val status: String,
    public val subnetId: String,
    public val subnetName: String,
    public val type: String,
    public val vpdId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eflo.outputs.GetSubnetsSubnet): GetSubnetsSubnet = GetSubnetsSubnet(
            cidr = javaType.cidr(),
            createTime = javaType.createTime(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            message = javaType.message(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            subnetId = javaType.subnetId(),
            subnetName = javaType.subnetName(),
            type = javaType.type(),
            vpdId = javaType.vpdId(),
            zoneId = javaType.zoneId(),
        )
    }
}
