@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpds.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Vpd IDs.
 * @property nameRegex
 * @property names A list of name of Vpds.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId Resource group id
 * @property status The Vpd status.
 * @property vpdId The id of the vpd.
 * @property vpdName The Name of the VPD.
 * @property vpds A list of Vpd Entries. Each element contains the following attributes:
 */
public data class GetVpdsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val vpdId: String? = null,
    public val vpdName: String? = null,
    public val vpds: List<GetVpdsVpd>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eflo.outputs.GetVpdsResult): GetVpdsResult =
            GetVpdsResult(
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
                pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
                resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                vpdId = javaType.vpdId().map({ args0 -> args0 }).orElse(null),
                vpdName = javaType.vpdName().map({ args0 -> args0 }).orElse(null),
                vpds = javaType.vpds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.eflo.kotlin.outputs.GetVpdsVpd.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
