@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eflo.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidr CIDR network segment
 * @property createTime The creation time of the resource
 * @property gmtModified Modification time
 * @property id The id of the vpd.
 * @property resourceGroupId The Resource group id
 * @property status The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
 * @property vpdId The id of the vpd.
 * @property vpdName The Name of the VPD.
 */
public data class GetVpdsVpd(
    public val cidr: String,
    public val createTime: String,
    public val gmtModified: String,
    public val id: String,
    public val resourceGroupId: String,
    public val status: String,
    public val vpdId: String,
    public val vpdName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eflo.outputs.GetVpdsVpd): GetVpdsVpd =
            GetVpdsVpd(
                cidr = javaType.cidr(),
                createTime = javaType.createTime(),
                gmtModified = javaType.gmtModified(),
                id = javaType.id(),
                resourceGroupId = javaType.resourceGroupId(),
                status = javaType.status(),
                vpdId = javaType.vpdId(),
                vpdName = javaType.vpdName(),
            )
    }
}
