@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin

import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterAdditionalVolume
import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterApplication
import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterPostInstallScript
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterAdditionalVolume.Companion.toKotlin as clusterAdditionalVolumeToKotlin
import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterApplication.Companion.toKotlin as clusterApplicationToKotlin
import com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterPostInstallScript.Companion.toKotlin as clusterPostInstallScriptToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.ehpc.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a Ehpc Cluster resource.
 * For information about Ehpc Cluster and how to use it, see [What is Cluster](https://www.alibabacloud.com/help/en/e-hpc/developer-reference/api-ehpc-2018-04-12-createcluster).
 * > **NOTE:** Available since v1.173.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^centos_7_6_x64*",
 *     owners: "system",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultFileSystem = new alicloud.nas.FileSystem("default", {
 *     storageType: "Performance",
 *     protocolType: "NFS",
 * });
 * const defaultMountTarget = new alicloud.nas.MountTarget("default", {
 *     fileSystemId: defaultFileSystem.id,
 *     accessGroupName: "DEFAULT_VPC_GROUP_NAME",
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultCluster = new alicloud.ehpc.Cluster("default", {
 *     clusterName: name,
 *     deployMode: "Simple",
 *     description: name,
 *     haEnable: false,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     imageOwnerAlias: "system",
 *     volumeProtocol: "nfs",
 *     volumeId: defaultFileSystem.id,
 *     volumeMountpoint: defaultMountTarget.mountTargetDomain,
 *     computeCount: 1,
 *     computeInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     loginCount: 1,
 *     loginInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     managerCount: 1,
 *     managerInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     osTag: "CentOS_7.6_64",
 *     schedulerType: "pbs",
 *     password: "your-password123",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_images = alicloud.ecs.get_images(name_regex="^centos_7_6_x64*",
 *     owners="system")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_file_system = alicloud.nas.FileSystem("default",
 *     storage_type="Performance",
 *     protocol_type="NFS")
 * default_mount_target = alicloud.nas.MountTarget("default",
 *     file_system_id=default_file_system.id,
 *     access_group_name="DEFAULT_VPC_GROUP_NAME",
 *     vswitch_id=default_switch.id)
 * default_cluster = alicloud.ehpc.Cluster("default",
 *     cluster_name=name,
 *     deploy_mode="Simple",
 *     description=name,
 *     ha_enable=False,
 *     image_id=default_get_images.images[0].id,
 *     image_owner_alias="system",
 *     volume_protocol="nfs",
 *     volume_id=default_file_system.id,
 *     volume_mountpoint=default_mount_target.mount_target_domain,
 *     compute_count=1,
 *     compute_instance_type=default_get_instance_types.instance_types[0].id,
 *     login_count=1,
 *     login_instance_type=default_get_instance_types.instance_types[0].id,
 *     manager_count=1,
 *     manager_instance_type=default_get_instance_types.instance_types[0].id,
 *     os_tag="CentOS_7.6_64",
 *     scheduler_type="pbs",
 *     password="your-password123",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^centos_7_6_x64*",
 *         Owners = "system",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultFileSystem = new AliCloud.Nas.FileSystem("default", new()
 *     {
 *         StorageType = "Performance",
 *         ProtocolType = "NFS",
 *     });
 *     var defaultMountTarget = new AliCloud.Nas.MountTarget("default", new()
 *     {
 *         FileSystemId = defaultFileSystem.Id,
 *         AccessGroupName = "DEFAULT_VPC_GROUP_NAME",
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultCluster = new AliCloud.Ehpc.Cluster("default", new()
 *     {
 *         ClusterName = name,
 *         DeployMode = "Simple",
 *         Description = name,
 *         HaEnable = false,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         ImageOwnerAlias = "system",
 *         VolumeProtocol = "nfs",
 *         VolumeId = defaultFileSystem.Id,
 *         VolumeMountpoint = defaultMountTarget.MountTargetDomain,
 *         ComputeCount = 1,
 *         ComputeInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         LoginCount = 1,
 *         LoginInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         ManagerCount = 1,
 *         ManagerInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         OsTag = "CentOS_7.6_64",
 *         SchedulerType = "pbs",
 *         Password = "your-password123",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^centos_7_6_x64*"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := nas.NewFileSystem(ctx, "default", &nas.FileSystemArgs{
 * 			StorageType:  pulumi.String("Performance"),
 * 			ProtocolType: pulumi.String("NFS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMountTarget, err := nas.NewMountTarget(ctx, "default", &nas.MountTargetArgs{
 * 			FileSystemId:    defaultFileSystem.ID(),
 * 			AccessGroupName: pulumi.String("DEFAULT_VPC_GROUP_NAME"),
 * 			VswitchId:       defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ehpc.NewCluster(ctx, "default", &ehpc.ClusterArgs{
 * 			ClusterName:         pulumi.String(name),
 * 			DeployMode:          pulumi.String("Simple"),
 * 			Description:         pulumi.String(name),
 * 			HaEnable:            pulumi.Bool(false),
 * 			ImageId:             pulumi.String(defaultGetImages.Images[0].Id),
 * 			ImageOwnerAlias:     pulumi.String("system"),
 * 			VolumeProtocol:      pulumi.String("nfs"),
 * 			VolumeId:            defaultFileSystem.ID(),
 * 			VolumeMountpoint:    defaultMountTarget.MountTargetDomain,
 * 			ComputeCount:        pulumi.Int(1),
 * 			ComputeInstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			LoginCount:          pulumi.Int(1),
 * 			LoginInstanceType:   pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			ManagerCount:        pulumi.Int(1),
 * 			ManagerInstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			OsTag:               pulumi.String("CentOS_7.6_64"),
 * 			SchedulerType:       pulumi.String("pbs"),
 * 			Password:            pulumi.String("your-password123"),
 * 			VswitchId:           defaultSwitch.ID(),
 * 			VpcId:               defaultNetwork.ID(),
 * 			ZoneId:              pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.MountTarget;
 * import com.pulumi.alicloud.nas.MountTargetArgs;
 * import com.pulumi.alicloud.ehpc.Cluster;
 * import com.pulumi.alicloud.ehpc.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^centos_7_6_x64*")
 *             .owners("system")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType("Performance")
 *             .protocolType("NFS")
 *             .build());
 *         var defaultMountTarget = new MountTarget("defaultMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(defaultFileSystem.id())
 *             .accessGroupName("DEFAULT_VPC_GROUP_NAME")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterName(name)
 *             .deployMode("Simple")
 *             .description(name)
 *             .haEnable(false)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .imageOwnerAlias("system")
 *             .volumeProtocol("nfs")
 *             .volumeId(defaultFileSystem.id())
 *             .volumeMountpoint(defaultMountTarget.mountTargetDomain())
 *             .computeCount(1)
 *             .computeInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .loginCount(1)
 *             .loginInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .managerCount(1)
 *             .managerInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .osTag("CentOS_7.6_64")
 *             .schedulerType("pbs")
 *             .password("your-password123")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: default
 *     properties:
 *       storageType: Performance
 *       protocolType: NFS
 *   defaultMountTarget:
 *     type: alicloud:nas:MountTarget
 *     name: default
 *     properties:
 *       fileSystemId: ${defaultFileSystem.id}
 *       accessGroupName: DEFAULT_VPC_GROUP_NAME
 *       vswitchId: ${defaultSwitch.id}
 *   defaultCluster:
 *     type: alicloud:ehpc:Cluster
 *     name: default
 *     properties:
 *       clusterName: ${name}
 *       deployMode: Simple
 *       description: ${name}
 *       haEnable: false
 *       imageId: ${defaultGetImages.images[0].id}
 *       imageOwnerAlias: system
 *       volumeProtocol: nfs
 *       volumeId: ${defaultFileSystem.id}
 *       volumeMountpoint: ${defaultMountTarget.mountTargetDomain}
 *       computeCount: 1
 *       computeInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       loginCount: 1
 *       loginInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       managerCount: 1
 *       managerInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       osTag: CentOS_7.6_64
 *       schedulerType: pbs
 *       password: your-password123
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^centos_7_6_x64*
 *         owners: system
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ehpc Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ehpc/cluster:Cluster example <id>
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.ehpc.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
     */
    public val accountType: Output<String>
        get() = javaResource.accountType().applyValue({ args0 -> args0 })

    /**
     * The additional volumes. See `additional_volumes` below.
     */
    public val additionalVolumes: Output<List<ClusterAdditionalVolume>>?
        get() = javaResource.additionalVolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        clusterAdditionalVolumeToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The application. See `application` below.
     */
    public val applications: Output<List<ClusterApplication>>
        get() = javaResource.applications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterApplicationToKotlin(args0)
                })
            })
        })

    /**
     * Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the E-HPC client. By default, the parameter is set to the latest version number.
     */
    public val clientVersion: Output<String>
        get() = javaResource.clientVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the cluster. The name must be `2` to `64` characters in length.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * The version of the cluster. Default value: `1.0`.
     */
    public val clusterVersion: Output<String>
        get() = javaResource.clusterVersion().applyValue({ args0 -> args0 })

    /**
     * The number of the compute nodes. Valid values: `1` to `99`.
     */
    public val computeCount: Output<Int>
        get() = javaResource.computeCount().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the compute nodes support hyper-threading. Default value: `true`.
     */
    public val computeEnableHt: Output<Boolean>?
        get() = javaResource.computeEnableHt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance type of the compute nodes.
     */
    public val computeInstanceType: Output<String>
        get() = javaResource.computeInstanceType().applyValue({ args0 -> args0 })

    /**
     * The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
     */
    public val computeSpotPriceLimit: Output<String>?
        get() = javaResource.computeSpotPriceLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
     * - `NoSpot`: The compute nodes are pay-as-you-go instances.
     * - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
     * - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
     */
    public val computeSpotStrategy: Output<String>?
        get() = javaResource.computeSpotStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
     * - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
     * - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
     * - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
     */
    public val deployMode: Output<String>
        get() = javaResource.deployMode().applyValue({ args0 -> args0 })

    /**
     * The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The billing method of the nodes.
     */
    public val ecsChargeType: Output<String>
        get() = javaResource.ecsChargeType().applyValue({ args0 -> args0 })

    /**
     * The version of E-HPC. By default, the parameter is set to the latest version number.
     */
    public val ehpcVersion: Output<String>
        get() = javaResource.ehpcVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
     */
    public val haEnable: Output<Boolean>
        get() = javaResource.haEnable().applyValue({ args0 -> args0 })

    /**
     * The ID of the image.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
     */
    public val imageOwnerAlias: Output<String>
        get() = javaResource.imageOwnerAlias().applyValue({ args0 -> args0 })

    /**
     * The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
     */
    public val inputFileUrl: Output<String>?
        get() = javaResource.inputFileUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable auto scaling. Default value: `false`.
     */
    public val isComputeEss: Output<Boolean>?
        get() = javaResource.isComputeEss().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The queue to which the compute nodes are added.
     */
    public val jobQueue: Output<String>?
        get() = javaResource.jobQueue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the AccessKey pair.
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of the logon nodes. Valid values: `1`.
     */
    public val loginCount: Output<Int>
        get() = javaResource.loginCount().applyValue({ args0 -> args0 })

    /**
     * The instance type of the logon nodes.
     */
    public val loginInstanceType: Output<String>
        get() = javaResource.loginInstanceType().applyValue({ args0 -> args0 })

    /**
     * The number of the management nodes. Valid values: 1 and 2.
     */
    public val managerCount: Output<Int>
        get() = javaResource.managerCount().applyValue({ args0 -> args0 })

    /**
     * The instance type of the management nodes.
     */
    public val managerInstanceType: Output<String>
        get() = javaResource.managerInstanceType().applyValue({ args0 -> args0 })

    /**
     * The image tag of the operating system.
     */
    public val osTag: Output<String>
        get() = javaResource.osTag().applyValue({ args0 -> args0 })

    /**
     * The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
     * * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
     * * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
     * - pluginMod: the mode of the plug-in. The following modes are supported:
     * - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
     * - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
     * - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
     * - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
     */
    public val plugin: Output<String>?
        get() = javaResource.plugin().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The post install script. See `post_install_script` below.
     */
    public val postInstallScripts: Output<List<ClusterPostInstallScript>>?
        get() = javaResource.postInstallScripts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        clusterPostInstallScriptToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The node of the RAM role.
     */
    public val ramNodeTypes: Output<List<String>>?
        get() = javaResource.ramNodeTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the Resource Access Management (RAM) role.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The release instance. Valid values: `true`.
     */
    public val releaseInstance: Output<Boolean>?
        get() = javaResource.releaseInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The remote directory to which the file system is mounted.
     */
    public val remoteDirectory: Output<String>
        get() = javaResource.remoteDirectory().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
     */
    public val remoteVisEnable: Output<Boolean>?
        get() = javaResource.remoteVisEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
     */
    public val sccClusterId: Output<String>
        get() = javaResource.sccClusterId().applyValue({ args0 -> args0 })

    /**
     * The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
     */
    public val schedulerType: Output<String>
        get() = javaResource.schedulerType().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group to which the cluster belongs.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
     */
    public val securityGroupName: Output<String>?
        get() = javaResource.securityGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
     * * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
     */
    public val systemDiskLevel: Output<String>?
        get() = javaResource.systemDiskLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
     */
    public val systemDiskSize: Output<Int>?
        get() = javaResource.systemDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
     */
    public val systemDiskType: Output<String>?
        get() = javaResource.systemDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })

    /**
     * The mount options of the file system.
     */
    public val volumeMountOption: Output<String>?
        get() = javaResource.volumeMountOption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mount target of the file system. Take note of the following information:
     * - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
     * - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
     */
    public val volumeMountpoint: Output<String>
        get() = javaResource.volumeMountpoint().applyValue({ args0 -> args0 })

    /**
     * The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
     */
    public val volumeProtocol: Output<String>
        get() = javaResource.volumeProtocol().applyValue({ args0 -> args0 })

    /**
     * The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
     */
    public val volumeType: Output<String>
        get() = javaResource.volumeType().applyValue({ args0 -> args0 })

    /**
     * The ID of the virtual private cloud (VPC) to which the cluster belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the vSwitch. E-HPC supports only VPC networks.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether not to install the agent. Default value: `false`.
     */
    public val withoutAgent: Output<Boolean>?
        get() = javaResource.withoutAgent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
     */
    public val withoutElasticIp: Output<Boolean>?
        get() = javaResource.withoutElasticIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the zone.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ehpc.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.ehpc.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
