@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin

import com.pulumi.alicloud.ehpc.ClusterArgs.builder
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterAdditionalVolumeArgs
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterAdditionalVolumeArgsBuilder
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterApplicationArgs
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterApplicationArgsBuilder
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterPostInstallScriptArgs
import com.pulumi.alicloud.ehpc.kotlin.inputs.ClusterPostInstallScriptArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Ehpc Cluster resource.
 * For information about Ehpc Cluster and how to use it, see [What is Cluster](https://www.alibabacloud.com/help/en/e-hpc/developer-reference/api-ehpc-2018-04-12-createcluster).
 * > **NOTE:** Available since v1.173.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^centos_7_6_x64*",
 *     owners: "system",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const defaultFileSystem = new alicloud.nas.FileSystem("default", {
 *     storageType: "Performance",
 *     protocolType: "NFS",
 * });
 * const defaultMountTarget = new alicloud.nas.MountTarget("default", {
 *     fileSystemId: defaultFileSystem.id,
 *     accessGroupName: "DEFAULT_VPC_GROUP_NAME",
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultCluster = new alicloud.ehpc.Cluster("default", {
 *     clusterName: name,
 *     deployMode: "Simple",
 *     description: name,
 *     haEnable: false,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     imageOwnerAlias: "system",
 *     volumeProtocol: "nfs",
 *     volumeId: defaultFileSystem.id,
 *     volumeMountpoint: defaultMountTarget.mountTargetDomain,
 *     computeCount: 1,
 *     computeInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     loginCount: 1,
 *     loginInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     managerCount: 1,
 *     managerInstanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     osTag: "CentOS_7.6_64",
 *     schedulerType: "pbs",
 *     password: "your-password123",
 *     vswitchId: defaultSwitch.id,
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_images = alicloud.ecs.get_images(name_regex="^centos_7_6_x64*",
 *     owners="system")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * default_file_system = alicloud.nas.FileSystem("default",
 *     storage_type="Performance",
 *     protocol_type="NFS")
 * default_mount_target = alicloud.nas.MountTarget("default",
 *     file_system_id=default_file_system.id,
 *     access_group_name="DEFAULT_VPC_GROUP_NAME",
 *     vswitch_id=default_switch.id)
 * default_cluster = alicloud.ehpc.Cluster("default",
 *     cluster_name=name,
 *     deploy_mode="Simple",
 *     description=name,
 *     ha_enable=False,
 *     image_id=default_get_images.images[0].id,
 *     image_owner_alias="system",
 *     volume_protocol="nfs",
 *     volume_id=default_file_system.id,
 *     volume_mountpoint=default_mount_target.mount_target_domain,
 *     compute_count=1,
 *     compute_instance_type=default_get_instance_types.instance_types[0].id,
 *     login_count=1,
 *     login_instance_type=default_get_instance_types.instance_types[0].id,
 *     manager_count=1,
 *     manager_instance_type=default_get_instance_types.instance_types[0].id,
 *     os_tag="CentOS_7.6_64",
 *     scheduler_type="pbs",
 *     password="your-password123",
 *     vswitch_id=default_switch.id,
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^centos_7_6_x64*",
 *         Owners = "system",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var defaultFileSystem = new AliCloud.Nas.FileSystem("default", new()
 *     {
 *         StorageType = "Performance",
 *         ProtocolType = "NFS",
 *     });
 *     var defaultMountTarget = new AliCloud.Nas.MountTarget("default", new()
 *     {
 *         FileSystemId = defaultFileSystem.Id,
 *         AccessGroupName = "DEFAULT_VPC_GROUP_NAME",
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultCluster = new AliCloud.Ehpc.Cluster("default", new()
 *     {
 *         ClusterName = name,
 *         DeployMode = "Simple",
 *         Description = name,
 *         HaEnable = false,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         ImageOwnerAlias = "system",
 *         VolumeProtocol = "nfs",
 *         VolumeId = defaultFileSystem.Id,
 *         VolumeMountpoint = defaultMountTarget.MountTargetDomain,
 *         ComputeCount = 1,
 *         ComputeInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         LoginCount = 1,
 *         LoginInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         ManagerCount = 1,
 *         ManagerInstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         OsTag = "CentOS_7.6_64",
 *         SchedulerType = "pbs",
 *         Password = "your-password123",
 *         VswitchId = defaultSwitch.Id,
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^centos_7_6_x64*"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := nas.NewFileSystem(ctx, "default", &nas.FileSystemArgs{
 * 			StorageType:  pulumi.String("Performance"),
 * 			ProtocolType: pulumi.String("NFS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultMountTarget, err := nas.NewMountTarget(ctx, "default", &nas.MountTargetArgs{
 * 			FileSystemId:    defaultFileSystem.ID(),
 * 			AccessGroupName: pulumi.String("DEFAULT_VPC_GROUP_NAME"),
 * 			VswitchId:       defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ehpc.NewCluster(ctx, "default", &ehpc.ClusterArgs{
 * 			ClusterName:         pulumi.String(name),
 * 			DeployMode:          pulumi.String("Simple"),
 * 			Description:         pulumi.String(name),
 * 			HaEnable:            pulumi.Bool(false),
 * 			ImageId:             pulumi.String(defaultGetImages.Images[0].Id),
 * 			ImageOwnerAlias:     pulumi.String("system"),
 * 			VolumeProtocol:      pulumi.String("nfs"),
 * 			VolumeId:            defaultFileSystem.ID(),
 * 			VolumeMountpoint:    defaultMountTarget.MountTargetDomain,
 * 			ComputeCount:        pulumi.Int(1),
 * 			ComputeInstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			LoginCount:          pulumi.Int(1),
 * 			LoginInstanceType:   pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			ManagerCount:        pulumi.Int(1),
 * 			ManagerInstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			OsTag:               pulumi.String("CentOS_7.6_64"),
 * 			SchedulerType:       pulumi.String("pbs"),
 * 			Password:            pulumi.String("your-password123"),
 * 			VswitchId:           defaultSwitch.ID(),
 * 			VpcId:               defaultNetwork.ID(),
 * 			ZoneId:              pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.MountTarget;
 * import com.pulumi.alicloud.nas.MountTargetArgs;
 * import com.pulumi.alicloud.ehpc.Cluster;
 * import com.pulumi.alicloud.ehpc.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^centos_7_6_x64*")
 *             .owners("system")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType("Performance")
 *             .protocolType("NFS")
 *             .build());
 *         var defaultMountTarget = new MountTarget("defaultMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(defaultFileSystem.id())
 *             .accessGroupName("DEFAULT_VPC_GROUP_NAME")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterName(name)
 *             .deployMode("Simple")
 *             .description(name)
 *             .haEnable(false)
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .imageOwnerAlias("system")
 *             .volumeProtocol("nfs")
 *             .volumeId(defaultFileSystem.id())
 *             .volumeMountpoint(defaultMountTarget.mountTargetDomain())
 *             .computeCount(1)
 *             .computeInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .loginCount(1)
 *             .loginInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .managerCount(1)
 *             .managerInstanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .osTag("CentOS_7.6_64")
 *             .schedulerType("pbs")
 *             .password("your-password123")
 *             .vswitchId(defaultSwitch.id())
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   defaultFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: default
 *     properties:
 *       storageType: Performance
 *       protocolType: NFS
 *   defaultMountTarget:
 *     type: alicloud:nas:MountTarget
 *     name: default
 *     properties:
 *       fileSystemId: ${defaultFileSystem.id}
 *       accessGroupName: DEFAULT_VPC_GROUP_NAME
 *       vswitchId: ${defaultSwitch.id}
 *   defaultCluster:
 *     type: alicloud:ehpc:Cluster
 *     name: default
 *     properties:
 *       clusterName: ${name}
 *       deployMode: Simple
 *       description: ${name}
 *       haEnable: false
 *       imageId: ${defaultGetImages.images[0].id}
 *       imageOwnerAlias: system
 *       volumeProtocol: nfs
 *       volumeId: ${defaultFileSystem.id}
 *       volumeMountpoint: ${defaultMountTarget.mountTargetDomain}
 *       computeCount: 1
 *       computeInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       loginCount: 1
 *       loginInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       managerCount: 1
 *       managerInstanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       osTag: CentOS_7.6_64
 *       schedulerType: pbs
 *       password: your-password123
 *       vswitchId: ${defaultSwitch.id}
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^centos_7_6_x64*
 *         owners: system
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ehpc Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ehpc/cluster:Cluster example <id>
 * ```
 * @property accountType The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
 * @property additionalVolumes The additional volumes. See `additional_volumes` below.
 * @property applications The application. See `application` below.
 * @property autoRenew Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
 * @property autoRenewPeriod The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
 * @property clientVersion The version of the E-HPC client. By default, the parameter is set to the latest version number.
 * @property clusterName The name of the cluster. The name must be `2` to `64` characters in length.
 * @property clusterVersion The version of the cluster. Default value: `1.0`.
 * @property computeCount The number of the compute nodes. Valid values: `1` to `99`.
 * @property computeEnableHt Specifies whether the compute nodes support hyper-threading. Default value: `true`.
 * @property computeInstanceType The instance type of the compute nodes.
 * @property computeSpotPriceLimit The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
 * @property computeSpotStrategy The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
 * - `NoSpot`: The compute nodes are pay-as-you-go instances.
 * - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
 * - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
 * @property deployMode The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
 * - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
 * - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
 * - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
 * @property description The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
 * @property domain The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
 * @property ecsChargeType The billing method of the nodes.
 * @property ehpcVersion The version of E-HPC. By default, the parameter is set to the latest version number.
 * @property haEnable Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
 * @property imageId The ID of the image.
 * @property imageOwnerAlias The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
 * @property inputFileUrl The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
 * @property isComputeEss Specifies whether to enable auto scaling. Default value: `false`.
 * @property jobQueue The queue to which the compute nodes are added.
 * @property keyPairName The name of the AccessKey pair.
 * @property loginCount The number of the logon nodes. Valid values: `1`.
 * @property loginInstanceType The instance type of the logon nodes.
 * @property managerCount The number of the management nodes. Valid values: 1 and 2.
 * @property managerInstanceType The instance type of the management nodes.
 * @property osTag The image tag of the operating system.
 * @property password The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
 * @property period The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
 * * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
 * * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
 * * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
 * @property periodUnit The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
 * @property plugin The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
 * - pluginMod: the mode of the plug-in. The following modes are supported:
 * - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
 * - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
 * - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
 * - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
 * @property postInstallScripts The post install script. See `post_install_script` below.
 * @property ramNodeTypes The node of the RAM role.
 * @property ramRoleName The name of the Resource Access Management (RAM) role.
 * @property releaseInstance The release instance. Valid values: `true`.
 * @property remoteDirectory The remote directory to which the file system is mounted.
 * @property remoteVisEnable Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
 * @property resourceGroupId The ID of the resource group.
 * @property sccClusterId The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
 * @property schedulerType The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
 * @property securityGroupId The ID of the security group to which the cluster belongs.
 * @property securityGroupName If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
 * @property systemDiskLevel The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
 * * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
 * * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
 * * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
 * * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
 * @property systemDiskSize The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
 * @property systemDiskType The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
 * @property volumeId The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
 * @property volumeMountOption The mount options of the file system.
 * @property volumeMountpoint The mount target of the file system. Take note of the following information:
 * - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
 * - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
 * @property volumeProtocol The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
 * @property volumeType The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
 * @property vpcId The ID of the virtual private cloud (VPC) to which the cluster belongs.
 * @property vswitchId The ID of the vSwitch. E-HPC supports only VPC networks.
 * @property withoutAgent Specifies whether not to install the agent. Default value: `false`.
 * @property withoutElasticIp Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
 * @property zoneId The ID of the zone.
 */
public data class ClusterArgs(
    public val accountType: Output<String>? = null,
    public val additionalVolumes: Output<List<ClusterAdditionalVolumeArgs>>? = null,
    public val applications: Output<List<ClusterApplicationArgs>>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val clientVersion: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterVersion: Output<String>? = null,
    public val computeCount: Output<Int>? = null,
    public val computeEnableHt: Output<Boolean>? = null,
    public val computeInstanceType: Output<String>? = null,
    public val computeSpotPriceLimit: Output<String>? = null,
    public val computeSpotStrategy: Output<String>? = null,
    public val deployMode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val ecsChargeType: Output<String>? = null,
    public val ehpcVersion: Output<String>? = null,
    public val haEnable: Output<Boolean>? = null,
    public val imageId: Output<String>? = null,
    public val imageOwnerAlias: Output<String>? = null,
    public val inputFileUrl: Output<String>? = null,
    public val isComputeEss: Output<Boolean>? = null,
    public val jobQueue: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val loginCount: Output<Int>? = null,
    public val loginInstanceType: Output<String>? = null,
    public val managerCount: Output<Int>? = null,
    public val managerInstanceType: Output<String>? = null,
    public val osTag: Output<String>? = null,
    public val password: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val plugin: Output<String>? = null,
    public val postInstallScripts: Output<List<ClusterPostInstallScriptArgs>>? = null,
    public val ramNodeTypes: Output<List<String>>? = null,
    public val ramRoleName: Output<String>? = null,
    public val releaseInstance: Output<Boolean>? = null,
    public val remoteDirectory: Output<String>? = null,
    public val remoteVisEnable: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sccClusterId: Output<String>? = null,
    public val schedulerType: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityGroupName: Output<String>? = null,
    public val systemDiskLevel: Output<String>? = null,
    public val systemDiskSize: Output<Int>? = null,
    public val systemDiskType: Output<String>? = null,
    public val volumeId: Output<String>? = null,
    public val volumeMountOption: Output<String>? = null,
    public val volumeMountpoint: Output<String>? = null,
    public val volumeProtocol: Output<String>? = null,
    public val volumeType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val withoutAgent: Output<Boolean>? = null,
    public val withoutElasticIp: Output<Boolean>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.ClusterArgs =
        com.pulumi.alicloud.ehpc.ClusterArgs.builder()
            .accountType(accountType?.applyValue({ args0 -> args0 }))
            .additionalVolumes(
                additionalVolumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .applications(
                applications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .clientVersion(clientVersion?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterVersion(clusterVersion?.applyValue({ args0 -> args0 }))
            .computeCount(computeCount?.applyValue({ args0 -> args0 }))
            .computeEnableHt(computeEnableHt?.applyValue({ args0 -> args0 }))
            .computeInstanceType(computeInstanceType?.applyValue({ args0 -> args0 }))
            .computeSpotPriceLimit(computeSpotPriceLimit?.applyValue({ args0 -> args0 }))
            .computeSpotStrategy(computeSpotStrategy?.applyValue({ args0 -> args0 }))
            .deployMode(deployMode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .ecsChargeType(ecsChargeType?.applyValue({ args0 -> args0 }))
            .ehpcVersion(ehpcVersion?.applyValue({ args0 -> args0 }))
            .haEnable(haEnable?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageOwnerAlias(imageOwnerAlias?.applyValue({ args0 -> args0 }))
            .inputFileUrl(inputFileUrl?.applyValue({ args0 -> args0 }))
            .isComputeEss(isComputeEss?.applyValue({ args0 -> args0 }))
            .jobQueue(jobQueue?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .loginCount(loginCount?.applyValue({ args0 -> args0 }))
            .loginInstanceType(loginInstanceType?.applyValue({ args0 -> args0 }))
            .managerCount(managerCount?.applyValue({ args0 -> args0 }))
            .managerInstanceType(managerInstanceType?.applyValue({ args0 -> args0 }))
            .osTag(osTag?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .plugin(plugin?.applyValue({ args0 -> args0 }))
            .postInstallScripts(
                postInstallScripts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ramNodeTypes(ramNodeTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .releaseInstance(releaseInstance?.applyValue({ args0 -> args0 }))
            .remoteDirectory(remoteDirectory?.applyValue({ args0 -> args0 }))
            .remoteVisEnable(remoteVisEnable?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sccClusterId(sccClusterId?.applyValue({ args0 -> args0 }))
            .schedulerType(schedulerType?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupName(securityGroupName?.applyValue({ args0 -> args0 }))
            .systemDiskLevel(systemDiskLevel?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .systemDiskType(systemDiskType?.applyValue({ args0 -> args0 }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 }))
            .volumeMountOption(volumeMountOption?.applyValue({ args0 -> args0 }))
            .volumeMountpoint(volumeMountpoint?.applyValue({ args0 -> args0 }))
            .volumeProtocol(volumeProtocol?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .withoutAgent(withoutAgent?.applyValue({ args0 -> args0 }))
            .withoutElasticIp(withoutElasticIp?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var accountType: Output<String>? = null

    private var additionalVolumes: Output<List<ClusterAdditionalVolumeArgs>>? = null

    private var applications: Output<List<ClusterApplicationArgs>>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var clientVersion: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var clusterVersion: Output<String>? = null

    private var computeCount: Output<Int>? = null

    private var computeEnableHt: Output<Boolean>? = null

    private var computeInstanceType: Output<String>? = null

    private var computeSpotPriceLimit: Output<String>? = null

    private var computeSpotStrategy: Output<String>? = null

    private var deployMode: Output<String>? = null

    private var description: Output<String>? = null

    private var domain: Output<String>? = null

    private var ecsChargeType: Output<String>? = null

    private var ehpcVersion: Output<String>? = null

    private var haEnable: Output<Boolean>? = null

    private var imageId: Output<String>? = null

    private var imageOwnerAlias: Output<String>? = null

    private var inputFileUrl: Output<String>? = null

    private var isComputeEss: Output<Boolean>? = null

    private var jobQueue: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var loginCount: Output<Int>? = null

    private var loginInstanceType: Output<String>? = null

    private var managerCount: Output<Int>? = null

    private var managerInstanceType: Output<String>? = null

    private var osTag: Output<String>? = null

    private var password: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var plugin: Output<String>? = null

    private var postInstallScripts: Output<List<ClusterPostInstallScriptArgs>>? = null

    private var ramNodeTypes: Output<List<String>>? = null

    private var ramRoleName: Output<String>? = null

    private var releaseInstance: Output<Boolean>? = null

    private var remoteDirectory: Output<String>? = null

    private var remoteVisEnable: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var sccClusterId: Output<String>? = null

    private var schedulerType: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupName: Output<String>? = null

    private var systemDiskLevel: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var systemDiskType: Output<String>? = null

    private var volumeId: Output<String>? = null

    private var volumeMountOption: Output<String>? = null

    private var volumeMountpoint: Output<String>? = null

    private var volumeProtocol: Output<String>? = null

    private var volumeType: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var withoutAgent: Output<Boolean>? = null

    private var withoutElasticIp: Output<Boolean>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
     */
    @JvmName("hkewhlwgantmkxbq")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value The additional volumes. See `additional_volumes` below.
     */
    @JvmName("vbydwvjtjrtmscnw")
    public suspend fun additionalVolumes(`value`: Output<List<ClusterAdditionalVolumeArgs>>) {
        this.additionalVolumes = value
    }

    @JvmName("tcuwaouamgqgfdpm")
    public suspend fun additionalVolumes(vararg values: Output<ClusterAdditionalVolumeArgs>) {
        this.additionalVolumes = Output.all(values.asList())
    }

    /**
     * @param values The additional volumes. See `additional_volumes` below.
     */
    @JvmName("kipmcstqbsomciyg")
    public suspend fun additionalVolumes(values: List<Output<ClusterAdditionalVolumeArgs>>) {
        this.additionalVolumes = Output.all(values)
    }

    /**
     * @param value The application. See `application` below.
     */
    @JvmName("mknxqlruaspyfoso")
    public suspend fun applications(`value`: Output<List<ClusterApplicationArgs>>) {
        this.applications = value
    }

    @JvmName("hyqyeoaanfoedmea")
    public suspend fun applications(vararg values: Output<ClusterApplicationArgs>) {
        this.applications = Output.all(values.asList())
    }

    /**
     * @param values The application. See `application` below.
     */
    @JvmName("ykyncenglsajysmn")
    public suspend fun applications(values: List<Output<ClusterApplicationArgs>>) {
        this.applications = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
     */
    @JvmName("noiakvlurjphcrib")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
     */
    @JvmName("phdorpegsysurynl")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The version of the E-HPC client. By default, the parameter is set to the latest version number.
     */
    @JvmName("bnbpnuadkbpruxty")
    public suspend fun clientVersion(`value`: Output<String>) {
        this.clientVersion = value
    }

    /**
     * @param value The name of the cluster. The name must be `2` to `64` characters in length.
     */
    @JvmName("yemahaptjvcrwnum")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The version of the cluster. Default value: `1.0`.
     */
    @JvmName("obkngrdoefnmljia")
    public suspend fun clusterVersion(`value`: Output<String>) {
        this.clusterVersion = value
    }

    /**
     * @param value The number of the compute nodes. Valid values: `1` to `99`.
     */
    @JvmName("nayvcdmvcphsaxbw")
    public suspend fun computeCount(`value`: Output<Int>) {
        this.computeCount = value
    }

    /**
     * @param value Specifies whether the compute nodes support hyper-threading. Default value: `true`.
     */
    @JvmName("lrxmedkwhnwoxdwy")
    public suspend fun computeEnableHt(`value`: Output<Boolean>) {
        this.computeEnableHt = value
    }

    /**
     * @param value The instance type of the compute nodes.
     */
    @JvmName("cmkhqtgetykxlkps")
    public suspend fun computeInstanceType(`value`: Output<String>) {
        this.computeInstanceType = value
    }

    /**
     * @param value The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
     */
    @JvmName("jvanpsweomtsoqom")
    public suspend fun computeSpotPriceLimit(`value`: Output<String>) {
        this.computeSpotPriceLimit = value
    }

    /**
     * @param value The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
     * - `NoSpot`: The compute nodes are pay-as-you-go instances.
     * - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
     * - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
     */
    @JvmName("eidvhmdrgyefakba")
    public suspend fun computeSpotStrategy(`value`: Output<String>) {
        this.computeSpotStrategy = value
    }

    /**
     * @param value The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
     * - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
     * - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
     * - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
     */
    @JvmName("tdhkwlheflpktplm")
    public suspend fun deployMode(`value`: Output<String>) {
        this.deployMode = value
    }

    /**
     * @param value The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    @JvmName("eojgoskwfcvcyrnt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
     */
    @JvmName("wpkrviumujpqecme")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The billing method of the nodes.
     */
    @JvmName("kplhgnjvafppasmk")
    public suspend fun ecsChargeType(`value`: Output<String>) {
        this.ecsChargeType = value
    }

    /**
     * @param value The version of E-HPC. By default, the parameter is set to the latest version number.
     */
    @JvmName("yhscqxbghpddtnmt")
    public suspend fun ehpcVersion(`value`: Output<String>) {
        this.ehpcVersion = value
    }

    /**
     * @param value Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
     */
    @JvmName("evftjrsswylfikbf")
    public suspend fun haEnable(`value`: Output<Boolean>) {
        this.haEnable = value
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("gygfryfqkgyfsqhd")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
     */
    @JvmName("plcgmvxhccuyjnrh")
    public suspend fun imageOwnerAlias(`value`: Output<String>) {
        this.imageOwnerAlias = value
    }

    /**
     * @param value The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
     */
    @JvmName("vogufneiixtdoioy")
    public suspend fun inputFileUrl(`value`: Output<String>) {
        this.inputFileUrl = value
    }

    /**
     * @param value Specifies whether to enable auto scaling. Default value: `false`.
     */
    @JvmName("ixqhudbojwtnkepw")
    public suspend fun isComputeEss(`value`: Output<Boolean>) {
        this.isComputeEss = value
    }

    /**
     * @param value The queue to which the compute nodes are added.
     */
    @JvmName("qpsndhjhafrtfmyu")
    public suspend fun jobQueue(`value`: Output<String>) {
        this.jobQueue = value
    }

    /**
     * @param value The name of the AccessKey pair.
     */
    @JvmName("buieqftpjjcldtjh")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The number of the logon nodes. Valid values: `1`.
     */
    @JvmName("lpwvhvvmqchetonw")
    public suspend fun loginCount(`value`: Output<Int>) {
        this.loginCount = value
    }

    /**
     * @param value The instance type of the logon nodes.
     */
    @JvmName("qndgvungmjbrkvcy")
    public suspend fun loginInstanceType(`value`: Output<String>) {
        this.loginInstanceType = value
    }

    /**
     * @param value The number of the management nodes. Valid values: 1 and 2.
     */
    @JvmName("ydbldkuvxslxyhnq")
    public suspend fun managerCount(`value`: Output<Int>) {
        this.managerCount = value
    }

    /**
     * @param value The instance type of the management nodes.
     */
    @JvmName("wlsagxsbxcxksqxh")
    public suspend fun managerInstanceType(`value`: Output<String>) {
        this.managerInstanceType = value
    }

    /**
     * @param value The image tag of the operating system.
     */
    @JvmName("vcvwyniyupquuujq")
    public suspend fun osTag(`value`: Output<String>) {
        this.osTag = value
    }

    /**
     * @param value The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
     */
    @JvmName("btqmpkpbwwpajlqx")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
     * * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
     * * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
     */
    @JvmName("ervhqvxrsajakjto")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
     */
    @JvmName("wivpyjtvkevngvew")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
     * - pluginMod: the mode of the plug-in. The following modes are supported:
     * - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
     * - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
     * - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
     * - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
     */
    @JvmName("tfceesmhyodwjiue")
    public suspend fun plugin(`value`: Output<String>) {
        this.plugin = value
    }

    /**
     * @param value The post install script. See `post_install_script` below.
     */
    @JvmName("ebrxkpgcqmckhtwl")
    public suspend fun postInstallScripts(`value`: Output<List<ClusterPostInstallScriptArgs>>) {
        this.postInstallScripts = value
    }

    @JvmName("dhxldowtbsrbuuss")
    public suspend fun postInstallScripts(vararg values: Output<ClusterPostInstallScriptArgs>) {
        this.postInstallScripts = Output.all(values.asList())
    }

    /**
     * @param values The post install script. See `post_install_script` below.
     */
    @JvmName("tfsvmrdqmwcejlix")
    public suspend fun postInstallScripts(values: List<Output<ClusterPostInstallScriptArgs>>) {
        this.postInstallScripts = Output.all(values)
    }

    /**
     * @param value The node of the RAM role.
     */
    @JvmName("afnonokrnrtjrwyd")
    public suspend fun ramNodeTypes(`value`: Output<List<String>>) {
        this.ramNodeTypes = value
    }

    @JvmName("udjptbdoopgbgjts")
    public suspend fun ramNodeTypes(vararg values: Output<String>) {
        this.ramNodeTypes = Output.all(values.asList())
    }

    /**
     * @param values The node of the RAM role.
     */
    @JvmName("wmpmiscbjfxcggsl")
    public suspend fun ramNodeTypes(values: List<Output<String>>) {
        this.ramNodeTypes = Output.all(values)
    }

    /**
     * @param value The name of the Resource Access Management (RAM) role.
     */
    @JvmName("orgowageewrafgif")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value The release instance. Valid values: `true`.
     */
    @JvmName("eyhpcxsflkfqjdei")
    public suspend fun releaseInstance(`value`: Output<Boolean>) {
        this.releaseInstance = value
    }

    /**
     * @param value The remote directory to which the file system is mounted.
     */
    @JvmName("vyvrajkaxarksgkd")
    public suspend fun remoteDirectory(`value`: Output<String>) {
        this.remoteDirectory = value
    }

    /**
     * @param value Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
     */
    @JvmName("wrmbidxmoybgowpb")
    public suspend fun remoteVisEnable(`value`: Output<Boolean>) {
        this.remoteVisEnable = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("egkslabikcfskdyn")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
     */
    @JvmName("fosabvquynrnuqau")
    public suspend fun sccClusterId(`value`: Output<String>) {
        this.sccClusterId = value
    }

    /**
     * @param value The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
     */
    @JvmName("axakbwdenmjcnskb")
    public suspend fun schedulerType(`value`: Output<String>) {
        this.schedulerType = value
    }

    /**
     * @param value The ID of the security group to which the cluster belongs.
     */
    @JvmName("fccgowgrecpxsdvm")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
     */
    @JvmName("rytobcffpeccjgpg")
    public suspend fun securityGroupName(`value`: Output<String>) {
        this.securityGroupName = value
    }

    /**
     * @param value The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
     * * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
     */
    @JvmName("dopgmpqubyvthxbl")
    public suspend fun systemDiskLevel(`value`: Output<String>) {
        this.systemDiskLevel = value
    }

    /**
     * @param value The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
     */
    @JvmName("sdkibtqkilhpcqyr")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
     */
    @JvmName("vufsqjnfuoxdtynv")
    public suspend fun systemDiskType(`value`: Output<String>) {
        this.systemDiskType = value
    }

    /**
     * @param value The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
     */
    @JvmName("ihcoyiiumhmeqmbq")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value The mount options of the file system.
     */
    @JvmName("sxvmhdrsdojmwasj")
    public suspend fun volumeMountOption(`value`: Output<String>) {
        this.volumeMountOption = value
    }

    /**
     * @param value The mount target of the file system. Take note of the following information:
     * - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
     * - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
     */
    @JvmName("yuwiwjhdptvknyfe")
    public suspend fun volumeMountpoint(`value`: Output<String>) {
        this.volumeMountpoint = value
    }

    /**
     * @param value The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
     */
    @JvmName("guvihcoslnbhcpha")
    public suspend fun volumeProtocol(`value`: Output<String>) {
        this.volumeProtocol = value
    }

    /**
     * @param value The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
     */
    @JvmName("vtljtihjmtxobgqs")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) to which the cluster belongs.
     */
    @JvmName("dbhfhsqyjlrxxctg")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vSwitch. E-HPC supports only VPC networks.
     */
    @JvmName("ldadaulkcupivmwl")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Specifies whether not to install the agent. Default value: `false`.
     */
    @JvmName("qnvbvhllujttacga")
    public suspend fun withoutAgent(`value`: Output<Boolean>) {
        this.withoutAgent = value
    }

    /**
     * @param value Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
     */
    @JvmName("ieewvuqrqgqaijlo")
    public suspend fun withoutElasticIp(`value`: Output<Boolean>) {
        this.withoutElasticIp = value
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("tmxxrkcwvechygtr")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The type of the domain account service. Valid values: `nis`, `ldap`. Default value: `nis`
     */
    @JvmName("ldydfdqjmtqqfnku")
    public suspend fun accountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value The additional volumes. See `additional_volumes` below.
     */
    @JvmName("qxhfnbmokiwottmn")
    public suspend fun additionalVolumes(`value`: List<ClusterAdditionalVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalVolumes = mapped
    }

    /**
     * @param argument The additional volumes. See `additional_volumes` below.
     */
    @JvmName("jgjbgfvyyttgwjol")
    public suspend fun additionalVolumes(argument: List<suspend ClusterAdditionalVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterAdditionalVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalVolumes = mapped
    }

    /**
     * @param argument The additional volumes. See `additional_volumes` below.
     */
    @JvmName("enfrsinhsntrsxhq")
    public suspend fun additionalVolumes(vararg argument: suspend ClusterAdditionalVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterAdditionalVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalVolumes = mapped
    }

    /**
     * @param argument The additional volumes. See `additional_volumes` below.
     */
    @JvmName("jvbvqxxsbwiefcbj")
    public suspend fun additionalVolumes(argument: suspend ClusterAdditionalVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterAdditionalVolumeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalVolumes = mapped
    }

    /**
     * @param values The additional volumes. See `additional_volumes` below.
     */
    @JvmName("gitlejmvgomrjhnd")
    public suspend fun additionalVolumes(vararg values: ClusterAdditionalVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalVolumes = mapped
    }

    /**
     * @param value The application. See `application` below.
     */
    @JvmName("xpkvqrabndwqtgnp")
    public suspend fun applications(`value`: List<ClusterApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param argument The application. See `application` below.
     */
    @JvmName("cwjtwbsovbypqaru")
    public suspend fun applications(argument: List<suspend ClusterApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param argument The application. See `application` below.
     */
    @JvmName("vvkexwknccuprkbm")
    public suspend fun applications(vararg argument: suspend ClusterApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param argument The application. See `application` below.
     */
    @JvmName("twckmgstvfgxhqxn")
    public suspend fun applications(argument: suspend ClusterApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterApplicationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.applications = mapped
    }

    /**
     * @param values The application. See `application` below.
     */
    @JvmName("tvchbemimxdgsltf")
    public suspend fun applications(vararg values: ClusterApplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the subscription. Default value: `false`.
     */
    @JvmName("kikqduimsdhqehuf")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The auto-renewal period of the subscription compute nodes. The parameter takes effect when AutoRenew is set to true.
     */
    @JvmName("gpxrhrmyqdtmqlfl")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The version of the E-HPC client. By default, the parameter is set to the latest version number.
     */
    @JvmName("qnutlfutebysuheo")
    public suspend fun clientVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientVersion = mapped
    }

    /**
     * @param value The name of the cluster. The name must be `2` to `64` characters in length.
     */
    @JvmName("havankneieeawoig")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The version of the cluster. Default value: `1.0`.
     */
    @JvmName("nivudmgapqfooalj")
    public suspend fun clusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterVersion = mapped
    }

    /**
     * @param value The number of the compute nodes. Valid values: `1` to `99`.
     */
    @JvmName("dkssoamwnvsprkho")
    public suspend fun computeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeCount = mapped
    }

    /**
     * @param value Specifies whether the compute nodes support hyper-threading. Default value: `true`.
     */
    @JvmName("jahxshqmqeqruttc")
    public suspend fun computeEnableHt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnableHt = mapped
    }

    /**
     * @param value The instance type of the compute nodes.
     */
    @JvmName("fqyyfkudelkcljjj")
    public suspend fun computeInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeInstanceType = mapped
    }

    /**
     * @param value The maximum hourly price of the compute nodes. A maximum of three decimal places can be used in the value of the parameter. The parameter is valid only when the ComputeSpotStrategy parameter is set to SpotWithPriceLimit.
     */
    @JvmName("snudoxxieuwnnydv")
    public suspend fun computeSpotPriceLimit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeSpotPriceLimit = mapped
    }

    /**
     * @param value The bidding method of the compute nodes. Default value: `NoSpot`. Valid values:
     * - `NoSpot`: The compute nodes are pay-as-you-go instances.
     * - `SpotWithPriceLimit`: The compute nodes are preemptible instances that have a user-defined maximum hourly price.
     * - `SpotAsPriceGo`: The compute nodes are preemptible instances for which the market price at the time of purchase is used as the bid price.
     */
    @JvmName("rjadecdcmcxfcbve")
    public suspend fun computeSpotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeSpotStrategy = mapped
    }

    /**
     * @param value The mode in which the cluster is deployed. Valid values: `Standard`, `Simple`, `Tiny`. Default value: Standard.
     * - `Standard`: An account node, a scheduling node, a logon node, and multiple compute nodes are separately deployed.
     * - `Simple`: A management node, a logon node, and multiple compute nodes are deployed. The management node consists of an account node and a scheduling node. The logon node and compute nodes are separately deployed.
     * - `Tiny`: A management node and multiple compute nodes are deployed. The management node consists of an account node, a scheduling node, and a logon node. The compute nodes are separately deployed.
     */
    @JvmName("kakeelwmyavhnnsd")
    public suspend fun deployMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployMode = mapped
    }

    /**
     * @param value The description of the cluster. The description must be `2` to `256` characters in length. It cannot start with `http://` or `https://`.
     */
    @JvmName("yjcgmsfatatppnkj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The domain name of the on-premises cluster. This parameter takes effect only when the AccoutType parameter is set to Idap.
     */
    @JvmName("bsvadsnkiyomqcjr")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The billing method of the nodes.
     */
    @JvmName("weyffnsfqadlpvkx")
    public suspend fun ecsChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsChargeType = mapped
    }

    /**
     * @param value The version of E-HPC. By default, the parameter is set to the latest version number.
     */
    @JvmName("pfwsdaxeecqdbexm")
    public suspend fun ehpcVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ehpcVersion = mapped
    }

    /**
     * @param value Specifies whether to enable the high availability feature. Default value: `false`.  **Note:** If high availability is enabled, a primary management node and a secondary management node are used.
     */
    @JvmName("cprkqcodkmxvjqhc")
    public suspend fun haEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haEnable = mapped
    }

    /**
     * @param value The ID of the image.
     */
    @JvmName("wxnwiklktmrsunek")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The type of the image. Valid values: `others`, `self`, `system`, `marketplace`. Default value: `system`.
     */
    @JvmName("snvdwpjugjkvdvhg")
    public suspend fun imageOwnerAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageOwnerAlias = mapped
    }

    /**
     * @param value The URL of the job files that are uploaded to an Object Storage Service (OSS) bucket.
     */
    @JvmName("tuuolfshoravsqhx")
    public suspend fun inputFileUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFileUrl = mapped
    }

    /**
     * @param value Specifies whether to enable auto scaling. Default value: `false`.
     */
    @JvmName("usmmaphniuesqbev")
    public suspend fun isComputeEss(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isComputeEss = mapped
    }

    /**
     * @param value The queue to which the compute nodes are added.
     */
    @JvmName("obrxxatrxsgvyhxd")
    public suspend fun jobQueue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobQueue = mapped
    }

    /**
     * @param value The name of the AccessKey pair.
     */
    @JvmName("wosrralfqbleccno")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The number of the logon nodes. Valid values: `1`.
     */
    @JvmName("ncmlvnjtccqncnpx")
    public suspend fun loginCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginCount = mapped
    }

    /**
     * @param value The instance type of the logon nodes.
     */
    @JvmName("ddsbmsmkbiedagew")
    public suspend fun loginInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginInstanceType = mapped
    }

    /**
     * @param value The number of the management nodes. Valid values: 1 and 2.
     */
    @JvmName("xnunxxocbwjjebfi")
    public suspend fun managerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerCount = mapped
    }

    /**
     * @param value The instance type of the management nodes.
     */
    @JvmName("vtddsihexfpgqpoo")
    public suspend fun managerInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerInstanceType = mapped
    }

    /**
     * @param value The image tag of the operating system.
     */
    @JvmName("pqweldrhkwybruqb")
    public suspend fun osTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osTag = mapped
    }

    /**
     * @param value The root password of the logon node. The password must be 8 to 30 characters in length and contain at least three of the following items: uppercase letters, lowercase letters, digits, and special characters. The password can contain the following special characters: `( ) ~ ! @ # $ % ^ & * - + = { } [ ] : ; ‘ < > , . ? /`. You must specify either `password` or `key_pair_name`. If both are specified, the Password parameter prevails.
     */
    @JvmName("jiffqbaxdhtmcpem")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The duration of the subscription. The unit of the duration is specified by the `period_unit` parameter. Default value: `1`.
     * * If you set PriceUnit to Year, the valid values of the Period parameter are 1, 2, and 3.
     * * If you set PriceUnit to Month, the valid values of the Period parameter are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
     * * If you set PriceUnit to Hour, the valid value of the Period parameter is 1.
     */
    @JvmName("lqecrxdmnpkpnqpr")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The unit of the subscription duration. Valid values: `Year`, `Month`, `Hour`. Default value: `Month`.
     */
    @JvmName("sqidsyaqafsriaos")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The mode configurations of the plug-in. This parameter takes effect only when the SchedulerType parameter is set to custom. The value must be a JSON string. The parameter contains the following parameters: pluginMod, pluginLocalPath, and pluginOssPath.
     * - pluginMod: the mode of the plug-in. The following modes are supported:
     * - oss: The plug-in is downloaded and decompressed from OSS to a local path. The local path is specified by the pluginLocalPath parameter.
     * - image: By default, the plug-in is stored in a pre-defined local path. The local path is specified by the pluginLocalPath parameter.
     * - pluginLocalPath: the local path where the plug-in is stored. We recommend that you select a shared directory in oss mode and a non-shared directory in image mode.
     * - pluginOssPath: the remote path where the plug-in is stored in OSS. This parameter takes effect only when the pluginMod parameter is set to oss.
     */
    @JvmName("ftqxovjwsknirdpv")
    public suspend fun plugin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plugin = mapped
    }

    /**
     * @param value The post install script. See `post_install_script` below.
     */
    @JvmName("vexptialjjubyojq")
    public suspend fun postInstallScripts(`value`: List<ClusterPostInstallScriptArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postInstallScripts = mapped
    }

    /**
     * @param argument The post install script. See `post_install_script` below.
     */
    @JvmName("syhulchlljsyxttl")
    public suspend fun postInstallScripts(argument: List<suspend ClusterPostInstallScriptArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterPostInstallScriptArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.postInstallScripts = mapped
    }

    /**
     * @param argument The post install script. See `post_install_script` below.
     */
    @JvmName("iyuohfpatqyhieqx")
    public suspend fun postInstallScripts(vararg argument: suspend ClusterPostInstallScriptArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterPostInstallScriptArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.postInstallScripts = mapped
    }

    /**
     * @param argument The post install script. See `post_install_script` below.
     */
    @JvmName("vsgaxmyikbsylblt")
    public suspend fun postInstallScripts(argument: suspend ClusterPostInstallScriptArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterPostInstallScriptArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.postInstallScripts = mapped
    }

    /**
     * @param values The post install script. See `post_install_script` below.
     */
    @JvmName("nmeyxuivcptrryrs")
    public suspend fun postInstallScripts(vararg values: ClusterPostInstallScriptArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postInstallScripts = mapped
    }

    /**
     * @param value The node of the RAM role.
     */
    @JvmName("cvfhmkcynejjaqnd")
    public suspend fun ramNodeTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramNodeTypes = mapped
    }

    /**
     * @param values The node of the RAM role.
     */
    @JvmName("jqbvixqaqpoaeiyd")
    public suspend fun ramNodeTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ramNodeTypes = mapped
    }

    /**
     * @param value The name of the Resource Access Management (RAM) role.
     */
    @JvmName("jaualoplclgqsbne")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value The release instance. Valid values: `true`.
     */
    @JvmName("dbywnhkyvjnjskwv")
    public suspend fun releaseInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseInstance = mapped
    }

    /**
     * @param value The remote directory to which the file system is mounted.
     */
    @JvmName("cjjctmbtfvmqrlsp")
    public suspend fun remoteDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDirectory = mapped
    }

    /**
     * @param value Specifies whether to enable Virtual Network Computing (VNC). Default value: `false`.
     */
    @JvmName("cwqhpcvxsqklpnbc")
    public suspend fun remoteVisEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVisEnable = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vgvfeigikhcuyjma")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the Super Computing Cluster (SCC) instance. If you specify the parameter, the SCC instance is moved to a new SCC cluster.
     */
    @JvmName("ftixpqsnaofvgcwx")
    public suspend fun sccClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sccClusterId = mapped
    }

    /**
     * @param value The type of the scheduler. Valid values: `pbs`, `slurm`, `opengridscheduler` and `deadline`. Default value: `pbs`.
     */
    @JvmName("ngbfkjwfiluaxwtv")
    public suspend fun schedulerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulerType = mapped
    }

    /**
     * @param value The ID of the security group to which the cluster belongs.
     */
    @JvmName("xebopdvpjvckrlno")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value If you do not use an existing security group, set the parameter to the name of a new security group. A default policy is applied to the new security group.
     */
    @JvmName("fvehwddymkitoqbt")
    public suspend fun securityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupName = mapped
    }

    /**
     * @param value The performance level of the ESSD that is used as the system disk. Default value: `PL1` For more information, see [ESSDs](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/essds). Valid values:
     * * `PL0`: A single ESSD can deliver up to 10,000 random read/write IOPS.
     * * `PL1`: A single ESSD can deliver up to 50,000 random read/write IOPS.
     * * `PL2`: A single ESSD can deliver up to 100,000 random read/write IOPS.
     * * `PL3`: A single ESSD can deliver up to 1,000,000 random read/write IOPS.
     */
    @JvmName("wwuaghqeusjnoqya")
    public suspend fun systemDiskLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskLevel = mapped
    }

    /**
     * @param value The size of the system disk. Unit: `GB`. Valid values: `40` to `500`. Default value: `40`.
     */
    @JvmName("gbfdefrtgjlnqnei")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value The type of the system disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd` or `cloud`. Default value: `cloud_ssd`.
     */
    @JvmName("qftwkbmjjaxefopj")
    public suspend fun systemDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskType = mapped
    }

    /**
     * @param value The ID of the file system. If you leave the parameter empty, a Performance NAS file system is created by default.
     */
    @JvmName("jxqfrutaywrhawqt")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    /**
     * @param value The mount options of the file system.
     */
    @JvmName("slmoryyuocevepgg")
    public suspend fun volumeMountOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMountOption = mapped
    }

    /**
     * @param value The mount target of the file system. Take note of the following information:
     * - If you do not specify the VolumeId parameter, you can leave the VolumeMountpoint parameter empty. A mount target is created by default.
     * - If you specify the VolumeId parameter, the VolumeMountpoint parameter is required.
     */
    @JvmName("lovwbptodthfbgwj")
    public suspend fun volumeMountpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMountpoint = mapped
    }

    /**
     * @param value The type of the protocol that is used by the file system. Valid values: `NFS`, `SMB`. Default value: `NFS`.
     */
    @JvmName("ctxluftcdnqloknj")
    public suspend fun volumeProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeProtocol = mapped
    }

    /**
     * @param value The type of the shared storage. Only Apsara File Storage NAS file systems are supported.
     */
    @JvmName("trpmtovxfnpngpdd")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) to which the cluster belongs.
     */
    @JvmName("hspxrvesrfhitrnq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch. E-HPC supports only VPC networks.
     */
    @JvmName("wfmugdwseyqsgukx")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value Specifies whether not to install the agent. Default value: `false`.
     */
    @JvmName("ipenggmcnbqtpxxu")
    public suspend fun withoutAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withoutAgent = mapped
    }

    /**
     * @param value Specifies whether the logon node uses an elastic IP address (EIP). Default value: `false`.
     */
    @JvmName("qpqtgkdjacoqxeni")
    public suspend fun withoutElasticIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withoutElasticIp = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("hvwmubuksghyasos")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        accountType = accountType,
        additionalVolumes = additionalVolumes,
        applications = applications,
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        clientVersion = clientVersion,
        clusterName = clusterName,
        clusterVersion = clusterVersion,
        computeCount = computeCount,
        computeEnableHt = computeEnableHt,
        computeInstanceType = computeInstanceType,
        computeSpotPriceLimit = computeSpotPriceLimit,
        computeSpotStrategy = computeSpotStrategy,
        deployMode = deployMode,
        description = description,
        domain = domain,
        ecsChargeType = ecsChargeType,
        ehpcVersion = ehpcVersion,
        haEnable = haEnable,
        imageId = imageId,
        imageOwnerAlias = imageOwnerAlias,
        inputFileUrl = inputFileUrl,
        isComputeEss = isComputeEss,
        jobQueue = jobQueue,
        keyPairName = keyPairName,
        loginCount = loginCount,
        loginInstanceType = loginInstanceType,
        managerCount = managerCount,
        managerInstanceType = managerInstanceType,
        osTag = osTag,
        password = password,
        period = period,
        periodUnit = periodUnit,
        plugin = plugin,
        postInstallScripts = postInstallScripts,
        ramNodeTypes = ramNodeTypes,
        ramRoleName = ramRoleName,
        releaseInstance = releaseInstance,
        remoteDirectory = remoteDirectory,
        remoteVisEnable = remoteVisEnable,
        resourceGroupId = resourceGroupId,
        sccClusterId = sccClusterId,
        schedulerType = schedulerType,
        securityGroupId = securityGroupId,
        securityGroupName = securityGroupName,
        systemDiskLevel = systemDiskLevel,
        systemDiskSize = systemDiskSize,
        systemDiskType = systemDiskType,
        volumeId = volumeId,
        volumeMountOption = volumeMountOption,
        volumeMountpoint = volumeMountpoint,
        volumeProtocol = volumeProtocol,
        volumeType = volumeType,
        vpcId = vpcId,
        vswitchId = vswitchId,
        withoutAgent = withoutAgent,
        withoutElasticIp = withoutElasticIp,
        zoneId = zoneId,
    )
}
