@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin

import com.pulumi.alicloud.ehpc.EhpcFunctions.getClustersPlain
import com.pulumi.alicloud.ehpc.EhpcFunctions.getJobTemplatesPlain
import com.pulumi.alicloud.ehpc.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.ehpc.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.ehpc.kotlin.inputs.GetJobTemplatesPlainArgs
import com.pulumi.alicloud.ehpc.kotlin.inputs.GetJobTemplatesPlainArgsBuilder
import com.pulumi.alicloud.ehpc.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.ehpc.kotlin.outputs.GetJobTemplatesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ehpc.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.ehpc.kotlin.outputs.GetJobTemplatesResult.Companion.toKotlin as getJobTemplatesResultToKotlin

public object EhpcFunctions {
    /**
     * This data source provides the Ehpc Clusters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.173.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ehpc.getClusters({
     *     ids: ["example_id"],
     * });
     * export const ehpcClusterId1 = ids.then(ids => ids.clusters?.[0]?.id);
     * const nameRegex = alicloud.ehpc.getClusters({
     *     nameRegex: "^my-Cluster",
     * });
     * export const ehpcClusterId2 = nameRegex.then(nameRegex => nameRegex.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ehpc.get_clusters(ids=["example_id"])
     * pulumi.export("ehpcClusterId1", ids.clusters[0].id)
     * name_regex = alicloud.ehpc.get_clusters(name_regex="^my-Cluster")
     * pulumi.export("ehpcClusterId2", name_regex.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ehpc.GetClusters.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Ehpc.GetClusters.Invoke(new()
     *     {
     *         NameRegex = "^my-Cluster",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ehpcClusterId1"] = ids&#46;Apply(getClustersResult => getClustersResult&#46;Clusters[0]?.Id),
     *         ["ehpcClusterId2"] = nameRegex&#46;Apply(getClustersResult => getClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ehpc.GetClusters(ctx, &ehpc.GetClustersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ehpcClusterId1", ids.Clusters[0].Id)
     * 		nameRegex, err := ehpc.GetClusters(ctx, &ehpc.GetClustersArgs{
     * 			NameRegex: pulumi.StringRef("^my-Cluster"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ehpcClusterId2", nameRegex.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ehpc.EhpcFunctions;
     * import com.pulumi.alicloud.ehpc.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EhpcFunctions.getClusters(GetClustersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("ehpcClusterId1", ids.applyValue(getClustersResult -> getClustersResult.clusters()[0].id()));
     *         final var nameRegex = EhpcFunctions.getClusters(GetClustersArgs.builder()
     *             .nameRegex("^my-Cluster")
     *             .build());
     *         ctx.export("ehpcClusterId2", nameRegex.applyValue(getClustersResult -> getClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ehpc:getClusters
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ehpc:getClusters
     *       Arguments:
     *         nameRegex: ^my-Cluster
     * outputs:
     *   ehpcClusterId1: ${ids.clusters[0].id}
     *   ehpcClusterId2: ${nameRegex.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Cluster IDs.
     * @param nameRegex A regex string to filter results by Cluster name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values:
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ehpc&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ehpc Job Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.ehpc.JobTemplate("default", {
     *     jobTemplateName: "example_value",
     *     commandLine: "./LammpsTest/lammps.pbs",
     * });
     * const ids = alicloud.ehpc.getJobTemplatesOutput({
     *     ids: [_default&#46;id],
     * });
     * export const ehpcJobTemplateId1 = ids.apply(ids => ids.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ehpc.JobTemplate("default",
     *     job_template_name="example_value",
     *     command_line="./LammpsTest/lammps.pbs")
     * ids = alicloud.ehpc.get_job_templates_output(ids=[default&#46;id])
     * pulumi.export("ehpcJobTemplateId1", ids.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Ehpc.JobTemplate("default", new()
     *     {
     *         JobTemplateName = "example_value",
     *         CommandLine = "./LammpsTest/lammps.pbs",
     *     });
     *     var ids = AliCloud.Ehpc.GetJobTemplates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ehpcJobTemplateId1"] = ids.Apply(getJobTemplatesResult => getJobTemplatesResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ehpc.NewJobTemplate(ctx, "default", &ehpc.JobTemplateArgs{
     * 			JobTemplateName: pulumi.String("example_value"),
     * 			CommandLine:     pulumi.String("./LammpsTest/lammps.pbs"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := ehpc.GetJobTemplatesOutput(ctx, ehpc.GetJobTemplatesOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("ehpcJobTemplateId1", ids.ApplyT(func(ids ehpc.GetJobTemplatesResult) (*string, error) {
     * 			return &ids.Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ehpc.JobTemplate;
     * import com.pulumi.alicloud.ehpc.JobTemplateArgs;
     * import com.pulumi.alicloud.ehpc.EhpcFunctions;
     * import com.pulumi.alicloud.ehpc.inputs.GetJobTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new JobTemplate("default", JobTemplateArgs.builder()
     *             .jobTemplateName("example_value")
     *             .commandLine("./LammpsTest/lammps.pbs")
     *             .build());
     *         final var ids = EhpcFunctions.getJobTemplates(GetJobTemplatesArgs.builder()
     *             .ids(default_.id())
     *             .build());
     *         ctx.export("ehpcJobTemplateId1", ids.applyValue(getJobTemplatesResult -> getJobTemplatesResult).applyValue(ids -> ids.applyValue(getJobTemplatesResult -> getJobTemplatesResult.id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:ehpc:JobTemplate
     *     properties:
     *       jobTemplateName: example_value
     *       commandLine: ./LammpsTest/lammps.pbs
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ehpc:getJobTemplates
     *       Arguments:
     *         ids:
     *           - ${default.id}
     * outputs:
     *   ehpcJobTemplateId1: ${ids.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getJobTemplates.
     * @return A collection of values returned by getJobTemplates.
     */
    public suspend fun getJobTemplates(argument: GetJobTemplatesPlainArgs): GetJobTemplatesResult =
        getJobTemplatesResultToKotlin(getJobTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getJobTemplates].
     * @param ids A list of Job Template IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getJobTemplates.
     */
    public suspend fun getJobTemplates(ids: List<String>? = null, outputFile: String? = null): GetJobTemplatesResult {
        val argument = GetJobTemplatesPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getJobTemplatesResultToKotlin(getJobTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ehpc&#46;kotlin&#46;inputs&#46;GetJobTemplatesPlainArgs].
     * @return A collection of values returned by getJobTemplates.
     */
    public suspend fun getJobTemplates(argument: suspend GetJobTemplatesPlainArgsBuilder.() -> Unit): GetJobTemplatesResult {
        val builder = GetJobTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobTemplatesResultToKotlin(getJobTemplatesPlain(builtArgument.toJava()).await())
    }
}
