@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [JobTemplate].
 */
@PulumiTagMarker
public class JobTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobTemplateArgs = JobTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobTemplateArgsBuilder.() -> Unit) {
        val builder = JobTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobTemplate {
        val builtJavaResource = com.pulumi.alicloud.ehpc.JobTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobTemplate(builtJavaResource)
    }
}

/**
 * Provides a Ehpc Job Template resource.
 * For information about Ehpc Job Template and how to use it, see [What is Job Template](https://www.alibabacloud.com/help/product/57664.html).
 * > **NOTE:** Available in v1.133.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ehpc.JobTemplate("default", {
 *     jobTemplateName: "example_value",
 *     commandLine: "./LammpsTest/lammps.pbs",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ehpc.JobTemplate("default",
 *     job_template_name="example_value",
 *     command_line="./LammpsTest/lammps.pbs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ehpc.JobTemplate("default", new()
 *     {
 *         JobTemplateName = "example_value",
 *         CommandLine = "./LammpsTest/lammps.pbs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ehpc.NewJobTemplate(ctx, "default", &ehpc.JobTemplateArgs{
 * 			JobTemplateName: pulumi.String("example_value"),
 * 			CommandLine:     pulumi.String("./LammpsTest/lammps.pbs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ehpc.JobTemplate;
 * import com.pulumi.alicloud.ehpc.JobTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new JobTemplate("default", JobTemplateArgs.builder()
 *             .jobTemplateName("example_value")
 *             .commandLine("./LammpsTest/lammps.pbs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ehpc:JobTemplate
 *     properties:
 *       jobTemplateName: example_value
 *       commandLine: ./LammpsTest/lammps.pbs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ehpc Job Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ehpc/jobTemplate:JobTemplate example <id>
 * ```
 */
public class JobTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.ehpc.JobTemplate,
) : KotlinCustomResource(javaResource, JobTemplateMapper) {
    /**
     * Queue Jobs, Is of the Form: 1-10:2.
     */
    public val arrayRequest: Output<String>?
        get() = javaResource.arrayRequest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Job Maximum Run Time.
     */
    public val clockTime: Output<String>?
        get() = javaResource.clockTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Job Commands.
     */
    public val commandLine: Output<String>
        get() = javaResource.commandLine().applyValue({ args0 -> args0 })

    /**
     * A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
     */
    public val gpu: Output<Int>?
        get() = javaResource.gpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A Job Template Name.
     */
    public val jobTemplateName: Output<String>
        get() = javaResource.jobTemplateName().applyValue({ args0 -> args0 })

    /**
     * A Single Compute Node Maximum Memory.
     */
    public val mem: Output<String>?
        get() = javaResource.mem().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
     */
    public val node: Output<Int>?
        get() = javaResource.node().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Job Commands the Directory.
     */
    public val packagePath: Output<String>?
        get() = javaResource.packagePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Job Priority.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Job Queue.
     */
    public val queue: Output<String>?
        get() = javaResource.queue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If the Job Is Support for the Re-Run.
     */
    public val reRunable: Output<Boolean>
        get() = javaResource.reRunable().applyValue({ args0 -> args0 })

    /**
     * The name of the user who performed the job.
     */
    public val runasUser: Output<String>?
        get() = javaResource.runasUser().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Error Output Path.
     */
    public val stderrRedirectPath: Output<String>?
        get() = javaResource.stderrRedirectPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Standard Output Path and.
     */
    public val stdoutRedirectPath: Output<String>?
        get() = javaResource.stdoutRedirectPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
     */
    public val task: Output<Int>?
        get() = javaResource.task().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A Single Task and the Number of Required Threads.
     */
    public val thread: Output<Int>?
        get() = javaResource.thread().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Job of the Environment Variable.
     */
    public val variables: Output<String>?
        get() = javaResource.variables().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object JobTemplateMapper : ResourceMapper<JobTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ehpc.JobTemplate::class == javaResource::class

    override fun map(javaResource: Resource): JobTemplate = JobTemplate(
        javaResource as
            com.pulumi.alicloud.ehpc.JobTemplate,
    )
}

/**
 * @see [JobTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobTemplate].
 */
public suspend fun jobTemplate(name: String, block: suspend JobTemplateResourceBuilder.() -> Unit): JobTemplate {
    val builder = JobTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobTemplate(name: String): JobTemplate {
    val builder = JobTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
