@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin

import com.pulumi.alicloud.ehpc.JobTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Ehpc Job Template resource.
 * For information about Ehpc Job Template and how to use it, see [What is Job Template](https://www.alibabacloud.com/help/product/57664.html).
 * > **NOTE:** Available in v1.133.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.ehpc.JobTemplate("default", {
 *     jobTemplateName: "example_value",
 *     commandLine: "./LammpsTest/lammps.pbs",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.ehpc.JobTemplate("default",
 *     job_template_name="example_value",
 *     command_line="./LammpsTest/lammps.pbs")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Ehpc.JobTemplate("default", new()
 *     {
 *         JobTemplateName = "example_value",
 *         CommandLine = "./LammpsTest/lammps.pbs",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ehpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ehpc.NewJobTemplate(ctx, "default", &ehpc.JobTemplateArgs{
 * 			JobTemplateName: pulumi.String("example_value"),
 * 			CommandLine:     pulumi.String("./LammpsTest/lammps.pbs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ehpc.JobTemplate;
 * import com.pulumi.alicloud.ehpc.JobTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new JobTemplate("default", JobTemplateArgs.builder()
 *             .jobTemplateName("example_value")
 *             .commandLine("./LammpsTest/lammps.pbs")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:ehpc:JobTemplate
 *     properties:
 *       jobTemplateName: example_value
 *       commandLine: ./LammpsTest/lammps.pbs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ehpc Job Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ehpc/jobTemplate:JobTemplate example <id>
 * ```
 * @property arrayRequest Queue Jobs, Is of the Form: 1-10:2.
 * @property clockTime Job Maximum Run Time.
 * @property commandLine Job Commands.
 * @property gpu A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
 * @property jobTemplateName A Job Template Name.
 * @property mem A Single Compute Node Maximum Memory.
 * @property node Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
 * @property packagePath Job Commands the Directory.
 * @property priority The Job Priority.
 * @property queue The Job Queue.
 * @property reRunable If the Job Is Support for the Re-Run.
 * @property runasUser The name of the user who performed the job.
 * @property stderrRedirectPath Error Output Path.
 * @property stdoutRedirectPath Standard Output Path and.
 * @property task A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
 * @property thread A Single Task and the Number of Required Threads.
 * @property variables The Job of the Environment Variable.
 */
public data class JobTemplateArgs(
    public val arrayRequest: Output<String>? = null,
    public val clockTime: Output<String>? = null,
    public val commandLine: Output<String>? = null,
    public val gpu: Output<Int>? = null,
    public val jobTemplateName: Output<String>? = null,
    public val mem: Output<String>? = null,
    public val node: Output<Int>? = null,
    public val packagePath: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val queue: Output<String>? = null,
    public val reRunable: Output<Boolean>? = null,
    public val runasUser: Output<String>? = null,
    public val stderrRedirectPath: Output<String>? = null,
    public val stdoutRedirectPath: Output<String>? = null,
    public val task: Output<Int>? = null,
    public val thread: Output<Int>? = null,
    public val variables: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.JobTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.JobTemplateArgs =
        com.pulumi.alicloud.ehpc.JobTemplateArgs.builder()
            .arrayRequest(arrayRequest?.applyValue({ args0 -> args0 }))
            .clockTime(clockTime?.applyValue({ args0 -> args0 }))
            .commandLine(commandLine?.applyValue({ args0 -> args0 }))
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .jobTemplateName(jobTemplateName?.applyValue({ args0 -> args0 }))
            .mem(mem?.applyValue({ args0 -> args0 }))
            .node(node?.applyValue({ args0 -> args0 }))
            .packagePath(packagePath?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .queue(queue?.applyValue({ args0 -> args0 }))
            .reRunable(reRunable?.applyValue({ args0 -> args0 }))
            .runasUser(runasUser?.applyValue({ args0 -> args0 }))
            .stderrRedirectPath(stderrRedirectPath?.applyValue({ args0 -> args0 }))
            .stdoutRedirectPath(stdoutRedirectPath?.applyValue({ args0 -> args0 }))
            .task(task?.applyValue({ args0 -> args0 }))
            .thread(thread?.applyValue({ args0 -> args0 }))
            .variables(variables?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTemplateArgs].
 */
@PulumiTagMarker
public class JobTemplateArgsBuilder internal constructor() {
    private var arrayRequest: Output<String>? = null

    private var clockTime: Output<String>? = null

    private var commandLine: Output<String>? = null

    private var gpu: Output<Int>? = null

    private var jobTemplateName: Output<String>? = null

    private var mem: Output<String>? = null

    private var node: Output<Int>? = null

    private var packagePath: Output<String>? = null

    private var priority: Output<Int>? = null

    private var queue: Output<String>? = null

    private var reRunable: Output<Boolean>? = null

    private var runasUser: Output<String>? = null

    private var stderrRedirectPath: Output<String>? = null

    private var stdoutRedirectPath: Output<String>? = null

    private var task: Output<Int>? = null

    private var thread: Output<Int>? = null

    private var variables: Output<String>? = null

    /**
     * @param value Queue Jobs, Is of the Form: 1-10:2.
     */
    @JvmName("nxitycjucmldbbcc")
    public suspend fun arrayRequest(`value`: Output<String>) {
        this.arrayRequest = value
    }

    /**
     * @param value Job Maximum Run Time.
     */
    @JvmName("unuqchhudmbpcqtf")
    public suspend fun clockTime(`value`: Output<String>) {
        this.clockTime = value
    }

    /**
     * @param value Job Commands.
     */
    @JvmName("fqpyxlkpoewritxr")
    public suspend fun commandLine(`value`: Output<String>) {
        this.commandLine = value
    }

    /**
     * @param value A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
     */
    @JvmName("ghrxdjnhahjdumsp")
    public suspend fun gpu(`value`: Output<Int>) {
        this.gpu = value
    }

    /**
     * @param value A Job Template Name.
     */
    @JvmName("dbyttlvuvwmiditj")
    public suspend fun jobTemplateName(`value`: Output<String>) {
        this.jobTemplateName = value
    }

    /**
     * @param value A Single Compute Node Maximum Memory.
     */
    @JvmName("gfgmllldbdlbathx")
    public suspend fun mem(`value`: Output<String>) {
        this.mem = value
    }

    /**
     * @param value Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
     */
    @JvmName("nneivetbvrmvtmuu")
    public suspend fun node(`value`: Output<Int>) {
        this.node = value
    }

    /**
     * @param value Job Commands the Directory.
     */
    @JvmName("teprnrglssudnfuo")
    public suspend fun packagePath(`value`: Output<String>) {
        this.packagePath = value
    }

    /**
     * @param value The Job Priority.
     */
    @JvmName("xkwdubpoubbvtger")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Job Queue.
     */
    @JvmName("mfekbalasdrdboal")
    public suspend fun queue(`value`: Output<String>) {
        this.queue = value
    }

    /**
     * @param value If the Job Is Support for the Re-Run.
     */
    @JvmName("bxesdwmwyxhbgvyt")
    public suspend fun reRunable(`value`: Output<Boolean>) {
        this.reRunable = value
    }

    /**
     * @param value The name of the user who performed the job.
     */
    @JvmName("gtbgtkmxsdlnkvra")
    public suspend fun runasUser(`value`: Output<String>) {
        this.runasUser = value
    }

    /**
     * @param value Error Output Path.
     */
    @JvmName("vwujtkdesagynfjb")
    public suspend fun stderrRedirectPath(`value`: Output<String>) {
        this.stderrRedirectPath = value
    }

    /**
     * @param value Standard Output Path and.
     */
    @JvmName("blngtvvittqaolaa")
    public suspend fun stdoutRedirectPath(`value`: Output<String>) {
        this.stdoutRedirectPath = value
    }

    /**
     * @param value A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
     */
    @JvmName("iccdkevdkynrmsaq")
    public suspend fun task(`value`: Output<Int>) {
        this.task = value
    }

    /**
     * @param value A Single Task and the Number of Required Threads.
     */
    @JvmName("jrsgrbygjffqkkvx")
    public suspend fun thread(`value`: Output<Int>) {
        this.thread = value
    }

    /**
     * @param value The Job of the Environment Variable.
     */
    @JvmName("cenpdgctospfcwuy")
    public suspend fun variables(`value`: Output<String>) {
        this.variables = value
    }

    /**
     * @param value Queue Jobs, Is of the Form: 1-10:2.
     */
    @JvmName("cltnuaexijerhogs")
    public suspend fun arrayRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arrayRequest = mapped
    }

    /**
     * @param value Job Maximum Run Time.
     */
    @JvmName("pgfushxgisewmcsb")
    public suspend fun clockTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clockTime = mapped
    }

    /**
     * @param value Job Commands.
     */
    @JvmName("xgbohmyoiiylsmrg")
    public suspend fun commandLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandLine = mapped
    }

    /**
     * @param value A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
     */
    @JvmName("uythliuwjohwsfbx")
    public suspend fun gpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value A Job Template Name.
     */
    @JvmName("darrxwsrskhaiahm")
    public suspend fun jobTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobTemplateName = mapped
    }

    /**
     * @param value A Single Compute Node Maximum Memory.
     */
    @JvmName("jwlnobptnrgsrgrv")
    public suspend fun mem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mem = mapped
    }

    /**
     * @param value Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
     */
    @JvmName("iyeaenclusggeoej")
    public suspend fun node(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.node = mapped
    }

    /**
     * @param value Job Commands the Directory.
     */
    @JvmName("qrcaeyhcptclqehl")
    public suspend fun packagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packagePath = mapped
    }

    /**
     * @param value The Job Priority.
     */
    @JvmName("rgihuotbyysjwohk")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Job Queue.
     */
    @JvmName("icjufocouulghgct")
    public suspend fun queue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queue = mapped
    }

    /**
     * @param value If the Job Is Support for the Re-Run.
     */
    @JvmName("wdjuaaenonhhwgak")
    public suspend fun reRunable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reRunable = mapped
    }

    /**
     * @param value The name of the user who performed the job.
     */
    @JvmName("bexrvmjrxafrvcny")
    public suspend fun runasUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runasUser = mapped
    }

    /**
     * @param value Error Output Path.
     */
    @JvmName("ksbumufpfjtbjpwl")
    public suspend fun stderrRedirectPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stderrRedirectPath = mapped
    }

    /**
     * @param value Standard Output Path and.
     */
    @JvmName("nyaretajrrffjkrs")
    public suspend fun stdoutRedirectPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stdoutRedirectPath = mapped
    }

    /**
     * @param value A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
     */
    @JvmName("qpqaektliqcohiai")
    public suspend fun task(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.task = mapped
    }

    /**
     * @param value A Single Task and the Number of Required Threads.
     */
    @JvmName("nevascsebpusdjqc")
    public suspend fun thread(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thread = mapped
    }

    /**
     * @param value The Job of the Environment Variable.
     */
    @JvmName("wcymruaaneyahnlx")
    public suspend fun variables(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): JobTemplateArgs = JobTemplateArgs(
        arrayRequest = arrayRequest,
        clockTime = clockTime,
        commandLine = commandLine,
        gpu = gpu,
        jobTemplateName = jobTemplateName,
        mem = mem,
        node = node,
        packagePath = packagePath,
        priority = priority,
        queue = queue,
        reRunable = reRunable,
        runasUser = runasUser,
        stderrRedirectPath = stderrRedirectPath,
        stdoutRedirectPath = stdoutRedirectPath,
        task = task,
        thread = thread,
        variables = variables,
    )
}
