@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.inputs

import com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property jobQueue The queue of the nodes to which the additional file system is attached.
 * @property localDirectory The local directory on which the additional file system is mounted.
 * @property location The type of the cluster. Valid value: `PublicCloud`.
 * @property remoteDirectory The remote directory to which the additional file system is mounted.
 * @property roles The roles. See `roles` below.
 * @property volumeId The ID of the additional file system.
 * @property volumeMountOption The mount options of the file system.
 * @property volumeMountpoint The mount target of the additional file system.
 * @property volumeProtocol The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
 * @property volumeType The type of the additional shared storage. Only NAS file systems are supported.
 */
public data class ClusterAdditionalVolumeArgs(
    public val jobQueue: Output<String>? = null,
    public val localDirectory: Output<String>? = null,
    public val location: Output<String>? = null,
    public val remoteDirectory: Output<String>? = null,
    public val roles: Output<List<ClusterAdditionalVolumeRoleArgs>>? = null,
    public val volumeId: Output<String>? = null,
    public val volumeMountOption: Output<String>? = null,
    public val volumeMountpoint: Output<String>? = null,
    public val volumeProtocol: Output<String>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeArgs =
        com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeArgs.builder()
            .jobQueue(jobQueue?.applyValue({ args0 -> args0 }))
            .localDirectory(localDirectory?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .remoteDirectory(remoteDirectory?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 }))
            .volumeMountOption(volumeMountOption?.applyValue({ args0 -> args0 }))
            .volumeMountpoint(volumeMountpoint?.applyValue({ args0 -> args0 }))
            .volumeProtocol(volumeProtocol?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterAdditionalVolumeArgs].
 */
@PulumiTagMarker
public class ClusterAdditionalVolumeArgsBuilder internal constructor() {
    private var jobQueue: Output<String>? = null

    private var localDirectory: Output<String>? = null

    private var location: Output<String>? = null

    private var remoteDirectory: Output<String>? = null

    private var roles: Output<List<ClusterAdditionalVolumeRoleArgs>>? = null

    private var volumeId: Output<String>? = null

    private var volumeMountOption: Output<String>? = null

    private var volumeMountpoint: Output<String>? = null

    private var volumeProtocol: Output<String>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value The queue of the nodes to which the additional file system is attached.
     */
    @JvmName("dxfjoaoyykacovcx")
    public suspend fun jobQueue(`value`: Output<String>) {
        this.jobQueue = value
    }

    /**
     * @param value The local directory on which the additional file system is mounted.
     */
    @JvmName("gwrudonlplathrgn")
    public suspend fun localDirectory(`value`: Output<String>) {
        this.localDirectory = value
    }

    /**
     * @param value The type of the cluster. Valid value: `PublicCloud`.
     */
    @JvmName("hnbjhptdxreilhnw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The remote directory to which the additional file system is mounted.
     */
    @JvmName("jhnyseptxxvrctec")
    public suspend fun remoteDirectory(`value`: Output<String>) {
        this.remoteDirectory = value
    }

    /**
     * @param value The roles. See `roles` below.
     */
    @JvmName("dboiujilewwvnvpo")
    public suspend fun roles(`value`: Output<List<ClusterAdditionalVolumeRoleArgs>>) {
        this.roles = value
    }

    @JvmName("pcxknvmhqqrwojhp")
    public suspend fun roles(vararg values: Output<ClusterAdditionalVolumeRoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The roles. See `roles` below.
     */
    @JvmName("pmbmujmbfuljdvnu")
    public suspend fun roles(values: List<Output<ClusterAdditionalVolumeRoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The ID of the additional file system.
     */
    @JvmName("obncqvbggqynxfpp")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value The mount options of the file system.
     */
    @JvmName("rtwvxwpeblqacaad")
    public suspend fun volumeMountOption(`value`: Output<String>) {
        this.volumeMountOption = value
    }

    /**
     * @param value The mount target of the additional file system.
     */
    @JvmName("dxljxcgyjspcrfpg")
    public suspend fun volumeMountpoint(`value`: Output<String>) {
        this.volumeMountpoint = value
    }

    /**
     * @param value The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
     */
    @JvmName("pxfnywgdppdxaxca")
    public suspend fun volumeProtocol(`value`: Output<String>) {
        this.volumeProtocol = value
    }

    /**
     * @param value The type of the additional shared storage. Only NAS file systems are supported.
     */
    @JvmName("jngpvshciqqsdkjb")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value The queue of the nodes to which the additional file system is attached.
     */
    @JvmName("bdbgsysnnedhfiwc")
    public suspend fun jobQueue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobQueue = mapped
    }

    /**
     * @param value The local directory on which the additional file system is mounted.
     */
    @JvmName("haditlmgeuvxefok")
    public suspend fun localDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localDirectory = mapped
    }

    /**
     * @param value The type of the cluster. Valid value: `PublicCloud`.
     */
    @JvmName("qaljfnooiwmuibjg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The remote directory to which the additional file system is mounted.
     */
    @JvmName("vmmaajegaegsmkgh")
    public suspend fun remoteDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDirectory = mapped
    }

    /**
     * @param value The roles. See `roles` below.
     */
    @JvmName("dqjlmqauubiqswbc")
    public suspend fun roles(`value`: List<ClusterAdditionalVolumeRoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument The roles. See `roles` below.
     */
    @JvmName("rojialhrlndndcik")
    public suspend fun roles(argument: List<suspend ClusterAdditionalVolumeRoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterAdditionalVolumeRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The roles. See `roles` below.
     */
    @JvmName("jdbhqgaedjjjabot")
    public suspend fun roles(vararg argument: suspend ClusterAdditionalVolumeRoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterAdditionalVolumeRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The roles. See `roles` below.
     */
    @JvmName("sxsefxcnwqshhxft")
    public suspend fun roles(argument: suspend ClusterAdditionalVolumeRoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterAdditionalVolumeRoleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values The roles. See `roles` below.
     */
    @JvmName("ooejnkfhkoedesox")
    public suspend fun roles(vararg values: ClusterAdditionalVolumeRoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The ID of the additional file system.
     */
    @JvmName("ritqbbjrupwwoiiv")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    /**
     * @param value The mount options of the file system.
     */
    @JvmName("nmyywfnekspasjtg")
    public suspend fun volumeMountOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMountOption = mapped
    }

    /**
     * @param value The mount target of the additional file system.
     */
    @JvmName("xxppohbtqybgenif")
    public suspend fun volumeMountpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMountpoint = mapped
    }

    /**
     * @param value The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
     */
    @JvmName("sfbchcalpphdgyxu")
    public suspend fun volumeProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeProtocol = mapped
    }

    /**
     * @param value The type of the additional shared storage. Only NAS file systems are supported.
     */
    @JvmName("khydmvfsbtscactm")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): ClusterAdditionalVolumeArgs = ClusterAdditionalVolumeArgs(
        jobQueue = jobQueue,
        localDirectory = localDirectory,
        location = location,
        remoteDirectory = remoteDirectory,
        roles = roles,
        volumeId = volumeId,
        volumeMountOption = volumeMountOption,
        volumeMountpoint = volumeMountpoint,
        volumeProtocol = volumeProtocol,
        volumeType = volumeType,
    )
}
