@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.inputs

import com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The type of the nodes to which the additional file system is attached.
 */
public data class ClusterAdditionalVolumeRoleArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeRoleArgs =
        com.pulumi.alicloud.ehpc.inputs.ClusterAdditionalVolumeRoleArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterAdditionalVolumeRoleArgs].
 */
@PulumiTagMarker
public class ClusterAdditionalVolumeRoleArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The type of the nodes to which the additional file system is attached.
     */
    @JvmName("hqrbhrailwqtndgb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the nodes to which the additional file system is attached.
     */
    @JvmName("nljyllfjatyocrbo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterAdditionalVolumeRoleArgs = ClusterAdditionalVolumeRoleArgs(
        name = name,
    )
}
