@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.inputs

import com.pulumi.alicloud.ehpc.inputs.ClusterApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tag The tag of the software.
 */
public data class ClusterApplicationArgs(
    public val tag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.inputs.ClusterApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.inputs.ClusterApplicationArgs =
        com.pulumi.alicloud.ehpc.inputs.ClusterApplicationArgs.builder()
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterApplicationArgs].
 */
@PulumiTagMarker
public class ClusterApplicationArgsBuilder internal constructor() {
    private var tag: Output<String>? = null

    /**
     * @param value The tag of the software.
     */
    @JvmName("hmdijqgwfjcttopk")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The tag of the software.
     */
    @JvmName("hjmwfsysqtgrupka")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): ClusterApplicationArgs = ClusterApplicationArgs(
        tag = tag,
    )
}
