@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.inputs

import com.pulumi.alicloud.ehpc.inputs.ClusterPostInstallScriptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property args The parameter that is used to run the script after the cluster is created.
 * @property url The URL that is used to download the script after the cluster is created.
 */
public data class ClusterPostInstallScriptArgs(
    public val args: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.inputs.ClusterPostInstallScriptArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.inputs.ClusterPostInstallScriptArgs =
        com.pulumi.alicloud.ehpc.inputs.ClusterPostInstallScriptArgs.builder()
            .args(args?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPostInstallScriptArgs].
 */
@PulumiTagMarker
public class ClusterPostInstallScriptArgsBuilder internal constructor() {
    private var args: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The parameter that is used to run the script after the cluster is created.
     */
    @JvmName("yligruodgirvywur")
    public suspend fun args(`value`: Output<String>) {
        this.args = value
    }

    /**
     * @param value The URL that is used to download the script after the cluster is created.
     */
    @JvmName("dyaabfgitqjqcyfr")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The parameter that is used to run the script after the cluster is created.
     */
    @JvmName("usvrchwejwigccdu")
    public suspend fun args(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The URL that is used to download the script after the cluster is created.
     */
    @JvmName("yiijnicwlcvxbjri")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ClusterPostInstallScriptArgs = ClusterPostInstallScriptArgs(
        args = args,
        url = url,
    )
}
