@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.inputs

import com.pulumi.alicloud.ehpc.inputs.GetJobTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getJobTemplates.
 * @property ids A list of Job Template IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetJobTemplatesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ehpc.inputs.GetJobTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ehpc.inputs.GetJobTemplatesPlainArgs =
        com.pulumi.alicloud.ehpc.inputs.GetJobTemplatesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetJobTemplatesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Job Template IDs.
     */
    @JvmName("vvciacgyglxmrnnb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Job Template IDs.
     */
    @JvmName("diiakylyouvtrumo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ostqiibolxkspabm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetJobTemplatesPlainArgs = GetJobTemplatesPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
