@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property jobQueue The queue of the nodes to which the additional file system is attached.
 * @property localDirectory The local directory on which the additional file system is mounted.
 * @property location The type of the cluster. Valid value: `PublicCloud`.
 * @property remoteDirectory The remote directory to which the additional file system is mounted.
 * @property roles The roles. See `roles` below.
 * @property volumeId The ID of the additional file system.
 * @property volumeMountOption The mount options of the file system.
 * @property volumeMountpoint The mount target of the additional file system.
 * @property volumeProtocol The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
 * @property volumeType The type of the additional shared storage. Only NAS file systems are supported.
 */
public data class ClusterAdditionalVolume(
    public val jobQueue: String? = null,
    public val localDirectory: String? = null,
    public val location: String? = null,
    public val remoteDirectory: String? = null,
    public val roles: List<ClusterAdditionalVolumeRole>? = null,
    public val volumeId: String? = null,
    public val volumeMountOption: String? = null,
    public val volumeMountpoint: String? = null,
    public val volumeProtocol: String? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ehpc.outputs.ClusterAdditionalVolume): ClusterAdditionalVolume = ClusterAdditionalVolume(
            jobQueue = javaType.jobQueue().map({ args0 -> args0 }).orElse(null),
            localDirectory = javaType.localDirectory().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            remoteDirectory = javaType.remoteDirectory().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ehpc.kotlin.outputs.ClusterAdditionalVolumeRole.Companion.toKotlin(args0)
                })
            }),
            volumeId = javaType.volumeId().map({ args0 -> args0 }).orElse(null),
            volumeMountOption = javaType.volumeMountOption().map({ args0 -> args0 }).orElse(null),
            volumeMountpoint = javaType.volumeMountpoint().map({ args0 -> args0 }).orElse(null),
            volumeProtocol = javaType.volumeProtocol().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
