@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountType The server type of the account.
 * @property applications
 * @property clientVersion The version number of the client used by the cluster.
 * @property clusterId The id of E-HPC Cluster.
 * @property clusterName The name of E-HPC cluster.
 * @property computeCount The number of compute nodes in the cluster.
 * @property computeInstanceType Cluster compute node specifications.
 * @property createTime The creation time of the resource.
 * @property deployMode Cluster deployment mode. Possible values:
 * - Standard: separate deployment of account nodes, scheduling nodes, login nodes, and compute nodes.
 * - Advanced:HA mode deployment.
 * - Simple: the account node and the scheduling node are deployed on one node, and the login node and the compute node are deployed separately.
 * - Tiny: account nodes, scheduling nodes, and login nodes are deployed on one node, and compute nodes are deployed separately.
 * - OneBox: account node, scheduling node, login node and compute node are deployed on one node.
 * @property description The description of E-HPC cluster.
 * @property haEnable Whether to turn on high availability. > If high availability is enabled, each control role in the cluster will use two primary and secondary instances.
 * @property id The ID of the Cluster.
 * @property imageId The ID of the Image.
 * @property imageOwnerAlias The type of the image.
 * @property loginCount The number of cluster login nodes. Only configuration 1 is supported.
 * @property loginInstanceType Cluster login node specifications.
 * @property managerCount
 * @property managerInstanceType The instance type of manager nodes.
 * @property osTag The image tag of the operating system.
 * @property postInstallScripts
 * @property remoteDirectory Mount the remote directory of the shared storage.
 * @property sccClusterId The SccCluster ID used by the cluster. If the cluster is not an SCC model, it is empty.
 * @property schedulerType Dispatch server type.
 * @property securityGroupId The ID of the security group.
 * @property status The status of the resource.
 * @property volumeId The ID of the NAS instance. Currently, you cannot automatically create an Alibaba Cloud NAS instance.
 * @property volumeMountpoint The mount target of the file system. Mount targets cannot be automatically created for NAS file systems.
 * @property volumeProtocol The type of the protocol that is used by the file system.
 * @property volumeType The type of the network shared storage. Valid value: NAS.
 * @property vpcId The ID of the VPC network.
 * @property vswitchId The vswitch id.
 * @property zoneId
 */
public data class GetClustersCluster(
    public val accountType: String,
    public val applications: List<GetClustersClusterApplication>,
    public val clientVersion: String,
    public val clusterId: String,
    public val clusterName: String,
    public val computeCount: Int,
    public val computeInstanceType: String,
    public val createTime: String,
    public val deployMode: String,
    public val description: String,
    public val haEnable: Boolean,
    public val id: String,
    public val imageId: String,
    public val imageOwnerAlias: String,
    public val loginCount: Int,
    public val loginInstanceType: String,
    public val managerCount: Int,
    public val managerInstanceType: String,
    public val osTag: String,
    public val postInstallScripts: List<GetClustersClusterPostInstallScript>,
    public val remoteDirectory: String,
    public val sccClusterId: String,
    public val schedulerType: String,
    public val securityGroupId: String,
    public val status: String,
    public val volumeId: String,
    public val volumeMountpoint: String,
    public val volumeProtocol: String,
    public val volumeType: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ehpc.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            accountType = javaType.accountType(),
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ehpc.kotlin.outputs.GetClustersClusterApplication.Companion.toKotlin(args0)
                })
            }),
            clientVersion = javaType.clientVersion(),
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            computeCount = javaType.computeCount(),
            computeInstanceType = javaType.computeInstanceType(),
            createTime = javaType.createTime(),
            deployMode = javaType.deployMode(),
            description = javaType.description(),
            haEnable = javaType.haEnable(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            imageOwnerAlias = javaType.imageOwnerAlias(),
            loginCount = javaType.loginCount(),
            loginInstanceType = javaType.loginInstanceType(),
            managerCount = javaType.managerCount(),
            managerInstanceType = javaType.managerInstanceType(),
            osTag = javaType.osTag(),
            postInstallScripts = javaType.postInstallScripts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ehpc.kotlin.outputs.GetClustersClusterPostInstallScript.Companion.toKotlin(args0)
                })
            }),
            remoteDirectory = javaType.remoteDirectory(),
            sccClusterId = javaType.sccClusterId(),
            schedulerType = javaType.schedulerType(),
            securityGroupId = javaType.securityGroupId(),
            status = javaType.status(),
            volumeId = javaType.volumeId(),
            volumeMountpoint = javaType.volumeMountpoint(),
            volumeProtocol = javaType.volumeProtocol(),
            volumeType = javaType.volumeType(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
