@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getJobTemplates.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property templates
 */
public data class GetJobTemplatesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val templates: List<GetJobTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ehpc.outputs.GetJobTemplatesResult): GetJobTemplatesResult = GetJobTemplatesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ehpc.kotlin.outputs.GetJobTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
