@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ehpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arrayRequest Queue Jobs, Is of the Form: 1-10:2.
 * @property clockTime Job Maximum Run Time.
 * @property commandLine Job Commands.
 * @property gpu A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
 * @property id The ID of the Job Template.
 * @property jobTemplateId The first ID of the resource.
 * @property jobTemplateName A Job Template Name.
 * @property mem A Single Compute Node Maximum Memory.
 * @property node Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
 * @property packagePath Job Commands the Directory.
 * @property priority The Job Priority.Possible Values: 0~9.
 * @property queue The Job Queue.
 * @property reRunable If the Job Is Support for the Re-Run.
 * @property runasUser The name of the user who performed the job.
 * @property stderrRedirectPath Error Output Path.
 * @property stdoutRedirectPath Standard Output Path and.
 * @property task A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
 * @property thread A Single Task and the Number of Required Threads.Possible Values: 1~20000.
 * @property variables The Job of the Environment Variable.
 */
public data class GetJobTemplatesTemplate(
    public val arrayRequest: String,
    public val clockTime: String,
    public val commandLine: String,
    public val gpu: Int,
    public val id: String,
    public val jobTemplateId: String,
    public val jobTemplateName: String,
    public val mem: String,
    public val node: Int,
    public val packagePath: String,
    public val priority: Int,
    public val queue: String,
    public val reRunable: Boolean,
    public val runasUser: String,
    public val stderrRedirectPath: String,
    public val stdoutRedirectPath: String,
    public val task: Int,
    public val thread: Int,
    public val variables: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ehpc.outputs.GetJobTemplatesTemplate): GetJobTemplatesTemplate = GetJobTemplatesTemplate(
            arrayRequest = javaType.arrayRequest(),
            clockTime = javaType.clockTime(),
            commandLine = javaType.commandLine(),
            gpu = javaType.gpu(),
            id = javaType.id(),
            jobTemplateId = javaType.jobTemplateId(),
            jobTemplateName = javaType.jobTemplateName(),
            mem = javaType.mem(),
            node = javaType.node(),
            packagePath = javaType.packagePath(),
            priority = javaType.priority(),
            queue = javaType.queue(),
            reRunable = javaType.reRunable(),
            runasUser = javaType.runasUser(),
            stderrRedirectPath = javaType.stderrRedirectPath(),
            stdoutRedirectPath = javaType.stdoutRedirectPath(),
            task = javaType.task(),
            thread = javaType.thread(),
            variables = javaType.variables(),
        )
    }
}
