@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AnycastEipAddress].
 */
@PulumiTagMarker
public class AnycastEipAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnycastEipAddressArgs = AnycastEipAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnycastEipAddressArgsBuilder.() -> Unit) {
        val builder = AnycastEipAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AnycastEipAddress {
        val builtJavaResource =
            com.pulumi.alicloud.eipanycast.AnycastEipAddress(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AnycastEipAddress(builtJavaResource)
    }
}

/**
 * Provides a Eipanycast Anycast Eip Address resource. Anycast Elastic IP Address.
 * For information about Eipanycast Anycast Eip Address and how to use it, see [What is Anycast Eip Address](https://www.alibabacloud.com/help/en/anycast-eip/latest/api-eipanycast-2020-03-09-allocateanycasteipaddress).
 * > **NOTE:** Available since v1.113.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.eipanycast.AnycastEipAddress("default", {
 *     anycastEipAddressName: name,
 *     description: name,
 *     bandwidth: 200,
 *     serviceLocation: "international",
 *     internetChargeType: "PayByTraffic",
 *     paymentType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eipanycast.AnycastEipAddress("default",
 *     anycast_eip_address_name=name,
 *     description=name,
 *     bandwidth=200,
 *     service_location="international",
 *     internet_charge_type="PayByTraffic",
 *     payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.EipAnycast.AnycastEipAddress("default", new()
 *     {
 *         AnycastEipAddressName = name,
 *         Description = name,
 *         Bandwidth = 200,
 *         ServiceLocation = "international",
 *         InternetChargeType = "PayByTraffic",
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eipanycast"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eipanycast.NewAnycastEipAddress(ctx, "default", &eipanycast.AnycastEipAddressArgs{
 * 			AnycastEipAddressName: pulumi.String(name),
 * 			Description:           pulumi.String(name),
 * 			Bandwidth:             pulumi.Int(200),
 * 			ServiceLocation:       pulumi.String("international"),
 * 			InternetChargeType:    pulumi.String("PayByTraffic"),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eipanycast.AnycastEipAddress;
 * import com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new AnycastEipAddress("default", AnycastEipAddressArgs.builder()
 *             .anycastEipAddressName(name)
 *             .description(name)
 *             .bandwidth(200)
 *             .serviceLocation("international")
 *             .internetChargeType("PayByTraffic")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:eipanycast:AnycastEipAddress
 *     properties:
 *       anycastEipAddressName: ${name}
 *       description: ${name}
 *       bandwidth: 200
 *       serviceLocation: international
 *       internetChargeType: PayByTraffic
 *       paymentType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eipanycast Anycast Eip Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eipanycast/anycastEipAddress:AnycastEipAddress example <id>
 * ```
 */
public class AnycastEipAddress internal constructor(
    override val javaResource: com.pulumi.alicloud.eipanycast.AnycastEipAddress,
) : KotlinCustomResource(javaResource, AnycastEipAddressMapper) {
    /**
     * Anycast EIP instance name.
     */
    public val anycastEipAddressName: Output<String>?
        get() = javaResource.anycastEipAddressName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The peak bandwidth of the Anycast EIP instance, in Mbps.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Anycast EIP instance creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Anycast EIP instance description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method of Anycast EIP instance. "PayByBandwidth": refers to the method of billing based on traffic.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The payment model of Anycast EIP instance. "PayAsYouGo": Refers to the post-paid mode.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Anycast EIP instance access area. "international": Refers to areas outside of Mainland China.
     */
    public val serviceLocation: Output<String>
        get() = javaResource.serviceLocation().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * List of resource-bound tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AnycastEipAddressMapper : ResourceMapper<AnycastEipAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eipanycast.AnycastEipAddress::class == javaResource::class

    override fun map(javaResource: Resource): AnycastEipAddress = AnycastEipAddress(
        javaResource as
            com.pulumi.alicloud.eipanycast.AnycastEipAddress,
    )
}

/**
 * @see [AnycastEipAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnycastEipAddress].
 */
public suspend fun anycastEipAddress(
    name: String,
    block: suspend AnycastEipAddressResourceBuilder.() -> Unit,
): AnycastEipAddress {
    val builder = AnycastEipAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnycastEipAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun anycastEipAddress(name: String): AnycastEipAddress {
    val builder = AnycastEipAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
