@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin

import com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Eipanycast Anycast Eip Address resource. Anycast Elastic IP Address.
 * For information about Eipanycast Anycast Eip Address and how to use it, see [What is Anycast Eip Address](https://www.alibabacloud.com/help/en/anycast-eip/latest/api-eipanycast-2020-03-09-allocateanycasteipaddress).
 * > **NOTE:** Available since v1.113.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.eipanycast.AnycastEipAddress("default", {
 *     anycastEipAddressName: name,
 *     description: name,
 *     bandwidth: 200,
 *     serviceLocation: "international",
 *     internetChargeType: "PayByTraffic",
 *     paymentType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eipanycast.AnycastEipAddress("default",
 *     anycast_eip_address_name=name,
 *     description=name,
 *     bandwidth=200,
 *     service_location="international",
 *     internet_charge_type="PayByTraffic",
 *     payment_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.EipAnycast.AnycastEipAddress("default", new()
 *     {
 *         AnycastEipAddressName = name,
 *         Description = name,
 *         Bandwidth = 200,
 *         ServiceLocation = "international",
 *         InternetChargeType = "PayByTraffic",
 *         PaymentType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eipanycast"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eipanycast.NewAnycastEipAddress(ctx, "default", &eipanycast.AnycastEipAddressArgs{
 * 			AnycastEipAddressName: pulumi.String(name),
 * 			Description:           pulumi.String(name),
 * 			Bandwidth:             pulumi.Int(200),
 * 			ServiceLocation:       pulumi.String("international"),
 * 			InternetChargeType:    pulumi.String("PayByTraffic"),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eipanycast.AnycastEipAddress;
 * import com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new AnycastEipAddress("default", AnycastEipAddressArgs.builder()
 *             .anycastEipAddressName(name)
 *             .description(name)
 *             .bandwidth(200)
 *             .serviceLocation("international")
 *             .internetChargeType("PayByTraffic")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:eipanycast:AnycastEipAddress
 *     properties:
 *       anycastEipAddressName: ${name}
 *       description: ${name}
 *       bandwidth: 200
 *       serviceLocation: international
 *       internetChargeType: PayByTraffic
 *       paymentType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Eipanycast Anycast Eip Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eipanycast/anycastEipAddress:AnycastEipAddress example <id>
 * ```
 * @property anycastEipAddressName Anycast EIP instance name.
 * @property bandwidth The peak bandwidth of the Anycast EIP instance, in Mbps.
 * @property description Anycast EIP instance description.
 * @property internetChargeType The billing method of Anycast EIP instance. "PayByBandwidth": refers to the method of billing based on traffic.
 * @property paymentType The payment model of Anycast EIP instance. "PayAsYouGo": Refers to the post-paid mode.
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property serviceLocation Anycast EIP instance access area. "international": Refers to areas outside of Mainland China.
 * @property tags List of resource-bound tags.
 */
public data class AnycastEipAddressArgs(
    public val anycastEipAddressName: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val serviceLocation: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs =
        com.pulumi.alicloud.eipanycast.AnycastEipAddressArgs.builder()
            .anycastEipAddressName(anycastEipAddressName?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .serviceLocation(serviceLocation?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AnycastEipAddressArgs].
 */
@PulumiTagMarker
public class AnycastEipAddressArgsBuilder internal constructor() {
    private var anycastEipAddressName: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var description: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var serviceLocation: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Anycast EIP instance name.
     */
    @JvmName("onbmknvoefdtyhlh")
    public suspend fun anycastEipAddressName(`value`: Output<String>) {
        this.anycastEipAddressName = value
    }

    /**
     * @param value The peak bandwidth of the Anycast EIP instance, in Mbps.
     */
    @JvmName("uapvflnjtgvqglcu")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Anycast EIP instance description.
     */
    @JvmName("ksjoqxtqjpckhpug")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The billing method of Anycast EIP instance. "PayByBandwidth": refers to the method of billing based on traffic.
     */
    @JvmName("jltknfygdjkytwgb")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The payment model of Anycast EIP instance. "PayAsYouGo": Refers to the post-paid mode.
     */
    @JvmName("dgvgxidwvjlptmsp")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("kddtqqehnvqmxwss")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Anycast EIP instance access area. "international": Refers to areas outside of Mainland China.
     */
    @JvmName("qjnyhxdcpehorxrw")
    public suspend fun serviceLocation(`value`: Output<String>) {
        this.serviceLocation = value
    }

    /**
     * @param value List of resource-bound tags.
     */
    @JvmName("xfvmaqeiotmettxl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Anycast EIP instance name.
     */
    @JvmName("eqlfvfatjcxodnoj")
    public suspend fun anycastEipAddressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anycastEipAddressName = mapped
    }

    /**
     * @param value The peak bandwidth of the Anycast EIP instance, in Mbps.
     */
    @JvmName("wcmfpfquopomjxyo")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Anycast EIP instance description.
     */
    @JvmName("gkdunlxiirogojut")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The billing method of Anycast EIP instance. "PayByBandwidth": refers to the method of billing based on traffic.
     */
    @JvmName("xbyandmfkbamujjd")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The payment model of Anycast EIP instance. "PayAsYouGo": Refers to the post-paid mode.
     */
    @JvmName("gfwqwqryfycxsxfq")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("xakckwqnbgufskhn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Anycast EIP instance access area. "international": Refers to areas outside of Mainland China.
     */
    @JvmName("ueayemvbbhluyhkc")
    public suspend fun serviceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLocation = mapped
    }

    /**
     * @param value List of resource-bound tags.
     */
    @JvmName("axbgibimueeesnbm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values List of resource-bound tags.
     */
    @JvmName("empnfthuejytnsai")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AnycastEipAddressArgs = AnycastEipAddressArgs(
        anycastEipAddressName = anycastEipAddressName,
        bandwidth = bandwidth,
        description = description,
        internetChargeType = internetChargeType,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        serviceLocation = serviceLocation,
        tags = tags,
    )
}
