@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin

import com.pulumi.alicloud.eipanycast.EipanycastFunctions.getAnycastEipAddressesPlain
import com.pulumi.alicloud.eipanycast.kotlin.inputs.GetAnycastEipAddressesPlainArgs
import com.pulumi.alicloud.eipanycast.kotlin.inputs.GetAnycastEipAddressesPlainArgsBuilder
import com.pulumi.alicloud.eipanycast.kotlin.outputs.GetAnycastEipAddressesResult
import com.pulumi.alicloud.eipanycast.kotlin.outputs.GetAnycastEipAddressesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object EipanycastFunctions {
    /**
     * This data source provides the Eipanycast Anycast Eip Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.113.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.eipanycast.getAnycastEipAddresses({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstEipanycastAnycastEipAddressId = example.then(example => example.addresses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.eipanycast.get_anycast_eip_addresses(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstEipanycastAnycastEipAddressId", example.addresses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.EipAnycast.GetAnycastEipAddresses.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEipanycastAnycastEipAddressId"] = example&#46;Apply(getAnycastEipAddressesResult => getAnycastEipAddressesResult&#46;Addresses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eipanycast"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eipanycast.GetAnycastEipAddresses(ctx, &eipanycast.GetAnycastEipAddressesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEipanycastAnycastEipAddressId", example.Addresses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eipanycast.EipanycastFunctions;
     * import com.pulumi.alicloud.eipanycast.inputs.GetAnycastEipAddressesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EipanycastFunctions.getAnycastEipAddresses(GetAnycastEipAddressesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstEipanycastAnycastEipAddressId", example.applyValue(getAnycastEipAddressesResult -> getAnycastEipAddressesResult.addresses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:eipanycast:getAnycastEipAddresses
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstEipanycastAnycastEipAddressId: ${example.addresses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAnycastEipAddresses.
     * @return A collection of values returned by getAnycastEipAddresses.
     */
    public suspend fun getAnycastEipAddresses(argument: GetAnycastEipAddressesPlainArgs): GetAnycastEipAddressesResult =
        toKotlin(getAnycastEipAddressesPlain(argument.toJava()).await())

    /**
     * @see [getAnycastEipAddresses].
     * @param anycastEipAddressName Anycast EIP instance name.
     * @param bindInstanceIds The bind instance ids.
     * @param businessStatus The business status of the Anycast EIP instance. -`Normal`: Normal state. -`FinancialLocked`: The status of arrears locked.
     * @param ids A list of Anycast Eip Address IDs.
     * @param internetChargeType The billing method of Anycast EIP instance. `PayByBandwidth`: refers to the method of billing based on traffic.
     * @param ipAddress Anycast EIP instance IP address.
     * @param nameRegex A regex string to filter results by Anycast Eip Address name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType The payment model of Anycast EIP instance. `PayAsYouGo`: Refers to the post-paid mode. Default value is `PayAsYouGo`.
     * @param serviceLocation Anycast EIP instance access area. `international`: Refers to areas outside of Mainland China.
     * @param status IP status。- `Associating`, `Unassociating`, `Allocated`, `Associated`, `Modifying`, `Releasing`, `Released`. Valid values: `Allocated`, `Associated`.
     * @return A collection of values returned by getAnycastEipAddresses.
     */
    public suspend fun getAnycastEipAddresses(
        anycastEipAddressName: String? = null,
        bindInstanceIds: List<String>? = null,
        businessStatus: String? = null,
        ids: List<String>? = null,
        internetChargeType: String? = null,
        ipAddress: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        serviceLocation: String? = null,
        status: String? = null,
    ): GetAnycastEipAddressesResult {
        val argument = GetAnycastEipAddressesPlainArgs(
            anycastEipAddressName = anycastEipAddressName,
            bindInstanceIds = bindInstanceIds,
            businessStatus = businessStatus,
            ids = ids,
            internetChargeType = internetChargeType,
            ipAddress = ipAddress,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            serviceLocation = serviceLocation,
            status = status,
        )
        return toKotlin(getAnycastEipAddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAnycastEipAddresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eipanycast&#46;kotlin&#46;inputs&#46;GetAnycastEipAddressesPlainArgs].
     * @return A collection of values returned by getAnycastEipAddresses.
     */
    public suspend fun getAnycastEipAddresses(argument: suspend GetAnycastEipAddressesPlainArgsBuilder.() -> Unit): GetAnycastEipAddressesResult {
        val builder = GetAnycastEipAddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAnycastEipAddressesPlain(builtArgument.toJava()).await())
    }
}
