@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin.inputs

import com.pulumi.alicloud.eipanycast.inputs.AnycastEipAddressAttachmentPopLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property popLocation The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas.
 */
public data class AnycastEipAddressAttachmentPopLocationArgs(
    public val popLocation: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eipanycast.inputs.AnycastEipAddressAttachmentPopLocationArgs> {
    override fun toJava(): com.pulumi.alicloud.eipanycast.inputs.AnycastEipAddressAttachmentPopLocationArgs =
        com.pulumi.alicloud.eipanycast.inputs.AnycastEipAddressAttachmentPopLocationArgs.builder()
            .popLocation(popLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnycastEipAddressAttachmentPopLocationArgs].
 */
@PulumiTagMarker
public class AnycastEipAddressAttachmentPopLocationArgsBuilder internal constructor() {
    private var popLocation: Output<String>? = null

    /**
     * @param value The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas.
     */
    @JvmName("bsdpsabilbsxiabs")
    public suspend fun popLocation(`value`: Output<String>) {
        this.popLocation = value
    }

    /**
     * @param value The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas.
     */
    @JvmName("gnlrvsqciqmjhpse")
    public suspend fun popLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.popLocation = mapped
    }

    internal fun build(): AnycastEipAddressAttachmentPopLocationArgs =
        AnycastEipAddressAttachmentPopLocationArgs(
            popLocation = popLocation,
        )
}
