@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin.inputs

import com.pulumi.alicloud.eipanycast.inputs.GetAnycastEipAddressesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAnycastEipAddresses.
 * @property anycastEipAddressName Anycast EIP instance name.
 * @property bindInstanceIds The bind instance ids.
 * @property businessStatus The business status of the Anycast EIP instance. -`Normal`: Normal state. -`FinancialLocked`: The status of arrears locked.
 * @property ids A list of Anycast Eip Address IDs.
 * @property internetChargeType The billing method of Anycast EIP instance. `PayByBandwidth`: refers to the method of billing based on traffic.
 * @property ipAddress Anycast EIP instance IP address.
 * @property nameRegex A regex string to filter results by Anycast Eip Address name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property paymentType The payment model of Anycast EIP instance. `PayAsYouGo`: Refers to the post-paid mode. Default value is `PayAsYouGo`.
 * @property serviceLocation Anycast EIP instance access area. `international`: Refers to areas outside of Mainland China.
 * @property status IP status。- `Associating`, `Unassociating`, `Allocated`, `Associated`, `Modifying`, `Releasing`, `Released`. Valid values: `Allocated`, `Associated`.
 */
public data class GetAnycastEipAddressesPlainArgs(
    public val anycastEipAddressName: String? = null,
    public val bindInstanceIds: List<String>? = null,
    public val businessStatus: String? = null,
    public val ids: List<String>? = null,
    public val internetChargeType: String? = null,
    public val ipAddress: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val serviceLocation: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eipanycast.inputs.GetAnycastEipAddressesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eipanycast.inputs.GetAnycastEipAddressesPlainArgs =
        com.pulumi.alicloud.eipanycast.inputs.GetAnycastEipAddressesPlainArgs.builder()
            .anycastEipAddressName(anycastEipAddressName?.let({ args0 -> args0 }))
            .bindInstanceIds(bindInstanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .businessStatus(businessStatus?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .internetChargeType(internetChargeType?.let({ args0 -> args0 }))
            .ipAddress(ipAddress?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .serviceLocation(serviceLocation?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAnycastEipAddressesPlainArgs].
 */
@PulumiTagMarker
public class GetAnycastEipAddressesPlainArgsBuilder internal constructor() {
    private var anycastEipAddressName: String? = null

    private var bindInstanceIds: List<String>? = null

    private var businessStatus: String? = null

    private var ids: List<String>? = null

    private var internetChargeType: String? = null

    private var ipAddress: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var paymentType: String? = null

    private var serviceLocation: String? = null

    private var status: String? = null

    /**
     * @param value Anycast EIP instance name.
     */
    @JvmName("qjeakpfjqhsnaeks")
    public suspend fun anycastEipAddressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.anycastEipAddressName = mapped
    }

    /**
     * @param value The bind instance ids.
     */
    @JvmName("dslncebyxklgjeqx")
    public suspend fun bindInstanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bindInstanceIds = mapped
    }

    /**
     * @param values The bind instance ids.
     */
    @JvmName("ailcllfykykflaig")
    public suspend fun bindInstanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bindInstanceIds = mapped
    }

    /**
     * @param value The business status of the Anycast EIP instance. -`Normal`: Normal state. -`FinancialLocked`: The status of arrears locked.
     */
    @JvmName("oxdcjfauxkccvblo")
    public suspend fun businessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.businessStatus = mapped
    }

    /**
     * @param value A list of Anycast Eip Address IDs.
     */
    @JvmName("pmgnndjyfvgtvhag")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Anycast Eip Address IDs.
     */
    @JvmName("vqelquxvvxnkujlt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The billing method of Anycast EIP instance. `PayByBandwidth`: refers to the method of billing based on traffic.
     */
    @JvmName("inxubuocsceqfdow")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internetChargeType = mapped
    }

    /**
     * @param value Anycast EIP instance IP address.
     */
    @JvmName("diyuxaieegbxrene")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipAddress = mapped
    }

    /**
     * @param value A regex string to filter results by Anycast Eip Address name.
     */
    @JvmName("ungdatlvsthcysfy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tmmvnohqbgjfpkyl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The payment model of Anycast EIP instance. `PayAsYouGo`: Refers to the post-paid mode. Default value is `PayAsYouGo`.
     */
    @JvmName("esukcudoidgpfqxl")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value Anycast EIP instance access area. `international`: Refers to areas outside of Mainland China.
     */
    @JvmName("mccmtdqoehbqfcgi")
    public suspend fun serviceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceLocation = mapped
    }

    /**
     * @param value IP status。- `Associating`, `Unassociating`, `Allocated`, `Associated`, `Modifying`, `Releasing`, `Released`. Valid values: `Allocated`, `Associated`.
     */
    @JvmName("fvttmxphjoplgvfu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAnycastEipAddressesPlainArgs = GetAnycastEipAddressesPlainArgs(
        anycastEipAddressName = anycastEipAddressName,
        bindInstanceIds = bindInstanceIds,
        businessStatus = businessStatus,
        ids = ids,
        internetChargeType = internetChargeType,
        ipAddress = ipAddress,
        nameRegex = nameRegex,
        outputFile = outputFile,
        paymentType = paymentType,
        serviceLocation = serviceLocation,
        status = status,
    )
}
