@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aliUid Anycast EIP instance account ID.
 * @property anycastEipAddressName Anycast EIP instance name.
 * @property anycastEipBindInfoLists AnycastEip binding information.
 * @property anycastId Anycast EIP instance ID.
 * @property bandwidth The peak bandwidth of the Anycast EIP instance, in Mbps.
 * @property bid Anycast EIP instance account BID.
 * @property businessStatus The business status of the Anycast EIP instance. -`Normal`: Normal state. -`FinancialLocked`: The status of arrears locked.
 * @property description Anycast EIP instance description.
 * @property id The ID of the Anycast Eip Address.
 * @property internetChargeType The billing method of Anycast EIP instance. `PayByBandwidth`: refers to the method of billing based on traffic.
 * @property ipAddress Anycast EIP instance IP address.
 * @property paymentType The payment model of Anycast EIP instance. "PostPaid": Refers to the post-paid mode.
 * @property serviceLocation Anycast EIP instance access area. "international": Refers to areas outside of Mainland China.
 * @property status IP status。- `Associating`, `Unassociating`, `Allocated`, `Associated`, `Modifying`, `Releasing`, `Released`.
 */
public data class GetAnycastEipAddressesAddress(
    public val aliUid: Int,
    public val anycastEipAddressName: String,
    public val anycastEipBindInfoLists: List<GetAnycastEipAddressesAddressAnycastEipBindInfoList>,
    public val anycastId: String,
    public val bandwidth: Int,
    public val bid: String,
    public val businessStatus: String,
    public val description: String,
    public val id: String,
    public val internetChargeType: String,
    public val ipAddress: String,
    public val paymentType: String,
    public val serviceLocation: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eipanycast.outputs.GetAnycastEipAddressesAddress): GetAnycastEipAddressesAddress = GetAnycastEipAddressesAddress(
            aliUid = javaType.aliUid(),
            anycastEipAddressName = javaType.anycastEipAddressName(),
            anycastEipBindInfoLists = javaType.anycastEipBindInfoLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eipanycast.kotlin.outputs.GetAnycastEipAddressesAddressAnycastEipBindInfoList.Companion.toKotlin(args0)
                })
            }),
            anycastId = javaType.anycastId(),
            bandwidth = javaType.bandwidth(),
            bid = javaType.bid(),
            businessStatus = javaType.businessStatus(),
            description = javaType.description(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            ipAddress = javaType.ipAddress(),
            paymentType = javaType.paymentType(),
            serviceLocation = javaType.serviceLocation(),
            status = javaType.status(),
        )
    }
}
