@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eipanycast.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAnycastEipAddresses.
 * @property addresses
 * @property anycastEipAddressName
 * @property bindInstanceIds
 * @property businessStatus
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property internetChargeType
 * @property ipAddress
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property paymentType
 * @property serviceLocation
 * @property status
 */
public data class GetAnycastEipAddressesResult(
    public val addresses: List<GetAnycastEipAddressesAddress>,
    public val anycastEipAddressName: String? = null,
    public val bindInstanceIds: List<String>? = null,
    public val businessStatus: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val internetChargeType: String? = null,
    public val ipAddress: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val paymentType: String? = null,
    public val serviceLocation: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eipanycast.outputs.GetAnycastEipAddressesResult): GetAnycastEipAddressesResult = GetAnycastEipAddressesResult(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eipanycast.kotlin.outputs.GetAnycastEipAddressesAddress.Companion.toKotlin(args0)
                })
            }),
            anycastEipAddressName = javaType.anycastEipAddressName().map({ args0 -> args0 }).orElse(null),
            bindInstanceIds = javaType.bindInstanceIds().map({ args0 -> args0 }),
            businessStatus = javaType.businessStatus().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            internetChargeType = javaType.internetChargeType().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            serviceLocation = javaType.serviceLocation().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
