@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.elasticsearch.kotlin

import com.pulumi.alicloud.elasticsearch.ElasticsearchFunctions.getInstancesPlain
import com.pulumi.alicloud.elasticsearch.ElasticsearchFunctions.getZonesPlain
import com.pulumi.alicloud.elasticsearch.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.elasticsearch.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.elasticsearch.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.elasticsearch.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.elasticsearch.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.elasticsearch.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.elasticsearch.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.elasticsearch.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object ElasticsearchFunctions {
    /**
     *
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param descriptionRegex
     * @param ids
     * @param outputFile
     * @param tags
     * @param version
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
        version: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            tags = tags,
            version = version,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;elasticsearch&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for Elasticsearch that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.elasticsearch.getZones({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.elasticsearch.get_zones()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.ElasticSearch.GetZones.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/elasticsearch"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := elasticsearch.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.elasticsearch.ElasticsearchFunctions;
     * import com.pulumi.alicloud.elasticsearch.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = ElasticsearchFunctions.getZones();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:elasticsearch:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch Elasticsearch instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;elasticsearch&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
