@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.elasticsearch.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.elasticsearch.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Elasticsearch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:elasticsearch/instance:Instance example es-cn-abcde123456
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.elasticsearch.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
     */
    public val autoRenewDuration: Output<Int>?
        get() = javaResource.autoRenewDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Elasticsearch cluster's client node quantity, between 2 and 25.
     */
    public val clientNodeAmount: Output<Int>?
        get() = javaResource.clientNodeAmount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The client node spec. If specified, client node will be created.
     */
    public val clientNodeSpec: Output<String>?
        get() = javaResource.clientNodeSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Elasticsearch cluster's data node quantity, between 2 and 50.
     */
    public val dataNodeAmount: Output<Int>
        get() = javaResource.dataNodeAmount().applyValue({ args0 -> args0 })

    /**
     * If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
     */
    public val dataNodeDiskEncrypted: Output<Boolean>?
        get() = javaResource.dataNodeDiskEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
     */
    public val dataNodeDiskPerformanceLevel: Output<String>?
        get() = javaResource.dataNodeDiskPerformanceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The single data node storage space.
     */
    public val dataNodeDiskSize: Output<Int>
        get() = javaResource.dataNodeDiskSize().applyValue({ args0 -> args0 })

    /**
     * The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
     */
    public val dataNodeDiskType: Output<String>
        get() = javaResource.dataNodeDiskType().applyValue({ args0 -> args0 })

    /**
     * The data node specifications of the Elasticsearch instance.
     */
    public val dataNodeSpec: Output<String>
        get() = javaResource.dataNodeSpec().applyValue({ args0 -> args0 })

    /**
     * The description of instance. It a string of 0 to 30 characters.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Instance connection domain (only VPC network access supported).
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * Bool, default to false. When it set to true, the instance can close kibana private network access。
     */
    public val enableKibanaPrivateNetwork: Output<Boolean>?
        get() = javaResource.enableKibanaPrivateNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Bool, default to true. When it set to false, the instance can enable kibana public network access。
     */
    public val enableKibanaPublicNetwork: Output<Boolean>?
        get() = javaResource.enableKibanaPublicNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Bool, default to false. When it set to true, the instance can enable public network access。
     */
    public val enablePublic: Output<Boolean>?
        get() = javaResource.enablePublic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
     */
    public val instanceChargeType: Output<String>?
        get() = javaResource.instanceChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kibana console domain (Internet access supported).
     */
    public val kibanaDomain: Output<String>
        get() = javaResource.kibanaDomain().applyValue({ args0 -> args0 })

    /**
     * The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
     */
    public val kibanaNodeSpec: Output<String>
        get() = javaResource.kibanaNodeSpec().applyValue({ args0 -> args0 })

    /**
     * Kibana console port.
     */
    public val kibanaPort: Output<Int>
        get() = javaResource.kibanaPort().applyValue({ args0 -> args0 })

    /**
     * the security group id associated with Kibana private network, this param is required when `enable_kibana_private_network` set true, and the security group id should in the same VPC as `vswitch_id`
     */
    public val kibanaPrivateSecurityGroupId: Output<String>?
        get() = javaResource.kibanaPrivateSecurityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
     */
    public val kibanaPrivateWhitelists: Output<List<String>>
        get() = javaResource.kibanaPrivateWhitelists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Set the Kibana's IP whitelist in internet network.
     */
    public val kibanaWhitelists: Output<List<String>>
        get() = javaResource.kibanaWhitelists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
     */
    public val masterNodeDiskType: Output<String>?
        get() = javaResource.masterNodeDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dedicated master node spec. If specified, dedicated master node will be created.
     */
    public val masterNodeSpec: Output<String>?
        get() = javaResource.masterNodeSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance connection port.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Set the instance's IP whitelist in VPC network.
     */
    public val privateWhitelists: Output<List<String>>
        get() = javaResource.privateWhitelists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance connection public domain.
     */
    public val publicDomain: Output<String>
        get() = javaResource.publicDomain().applyValue({ args0 -> args0 })

    /**
     * Instance connection public port.
     */
    public val publicPort: Output<Int>
        get() = javaResource.publicPort().applyValue({ args0 -> args0 })

    /**
     * Set the instance's IP whitelist in internet network.
     */
    public val publicWhitelists: Output<List<String>>
        get() = javaResource.publicWhitelists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
     */
    public val renewStatus: Output<String>?
        get() = javaResource.renewStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
     */
    public val renewalDurationUnit: Output<String>?
        get() = javaResource.renewalDurationUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of resource group which the Elasticsearch instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
     */
    public val settingConfig: Output<Map<String, String>>
        get() = javaResource.settingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Elasticsearch instance status. Includes `active`, `activating`, `inactive`. Some operations are denied when status is not `active`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` , `7.7_with_X-Pack`, `7.10_with_X-Pack`, `7.16_with_X-Pack`, `8.5_with_X-Pack`, `8.9_with_X-Pack`, `8.13_with_X-Pack`.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The ID of VSwitch.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Elasticsearch cluster's warm node quantity, between 3 and 50.
     */
    public val warmNodeAmount: Output<Int>?
        get() = javaResource.warmNodeAmount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If encrypt the warm node disk. Valid values are `true`, `false`. Default to `false`.
     */
    public val warmNodeDiskEncrypted: Output<Boolean>?
        get() = javaResource.warmNodeDiskEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The single warm node storage space, should between 500 and 20480
     */
    public val warmNodeDiskSize: Output<Int>?
        get() = javaResource.warmNodeDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The warm node disk type. Supported values:  cloud_efficiency.
     */
    public val warmNodeDiskType: Output<String>?
        get() = javaResource.warmNodeDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The warm node specifications of the Elasticsearch instance.
     */
    public val warmNodeSpec: Output<String>?
        get() = javaResource.warmNodeSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
     */
    public val zoneCount: Output<Int>?
        get() = javaResource.zoneCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.elasticsearch.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.elasticsearch.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
