@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.elasticsearch.kotlin

import com.pulumi.alicloud.elasticsearch.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Elasticsearch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:elasticsearch/instance:Instance example es-cn-abcde123456
 * ```
 * @property autoRenewDuration Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
 * @property clientNodeAmount The Elasticsearch cluster's client node quantity, between 2 and 25.
 * @property clientNodeSpec The client node spec. If specified, client node will be created.
 * @property dataNodeAmount The Elasticsearch cluster's data node quantity, between 2 and 50.
 * @property dataNodeDiskEncrypted If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
 * @property dataNodeDiskPerformanceLevel Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
 * @property dataNodeDiskSize The single data node storage space.
 * @property dataNodeDiskType The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
 * @property dataNodeSpec The data node specifications of the Elasticsearch instance.
 * @property description The description of instance. It a string of 0 to 30 characters.
 * @property enableKibanaPrivateNetwork Bool, default to false. When it set to true, the instance can close kibana private network access。
 * @property enableKibanaPublicNetwork Bool, default to true. When it set to false, the instance can enable kibana public network access。
 * @property enablePublic Bool, default to false. When it set to true, the instance can enable public network access。
 * @property instanceChargeType Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
 * @property kibanaNodeSpec The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
 * @property kibanaPrivateSecurityGroupId the security group id associated with Kibana private network, this param is required when `enable_kibana_private_network` set true, and the security group id should in the same VPC as `vswitch_id`
 * @property kibanaPrivateWhitelists Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
 * @property kibanaWhitelists Set the Kibana's IP whitelist in internet network.
 * @property kmsEncryptedPassword An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property masterNodeDiskType The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
 * @property masterNodeSpec The dedicated master node spec. If specified, dedicated master node will be created.
 * @property password The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
 * @property period The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
 * @property privateWhitelists Set the instance's IP whitelist in VPC network.
 * @property protocol Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
 * @property publicWhitelists Set the instance's IP whitelist in internet network.
 * @property renewStatus The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
 * @property renewalDurationUnit Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
 * @property resourceGroupId The ID of resource group which the Elasticsearch instance belongs.
 * @property settingConfig The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
 * @property tags A mapping of tags to assign to the resource.
 * @property version Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` , `7.7_with_X-Pack`, `7.10_with_X-Pack`, `7.16_with_X-Pack`, `8.5_with_X-Pack`, `8.9_with_X-Pack`, `8.13_with_X-Pack`.
 * @property vswitchId The ID of VSwitch.
 * @property warmNodeAmount The Elasticsearch cluster's warm node quantity, between 3 and 50.
 * @property warmNodeDiskEncrypted If encrypt the warm node disk. Valid values are `true`, `false`. Default to `false`.
 * @property warmNodeDiskSize The single warm node storage space, should between 500 and 20480
 * @property warmNodeDiskType The warm node disk type. Supported values:  cloud_efficiency.
 * @property warmNodeSpec The warm node specifications of the Elasticsearch instance.
 * @property zoneCount The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
 */
public data class InstanceArgs(
    public val autoRenewDuration: Output<Int>? = null,
    public val clientNodeAmount: Output<Int>? = null,
    public val clientNodeSpec: Output<String>? = null,
    public val dataNodeAmount: Output<Int>? = null,
    public val dataNodeDiskEncrypted: Output<Boolean>? = null,
    public val dataNodeDiskPerformanceLevel: Output<String>? = null,
    public val dataNodeDiskSize: Output<Int>? = null,
    public val dataNodeDiskType: Output<String>? = null,
    public val dataNodeSpec: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enableKibanaPrivateNetwork: Output<Boolean>? = null,
    public val enableKibanaPublicNetwork: Output<Boolean>? = null,
    public val enablePublic: Output<Boolean>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val kibanaNodeSpec: Output<String>? = null,
    public val kibanaPrivateSecurityGroupId: Output<String>? = null,
    public val kibanaPrivateWhitelists: Output<List<String>>? = null,
    public val kibanaWhitelists: Output<List<String>>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val masterNodeDiskType: Output<String>? = null,
    public val masterNodeSpec: Output<String>? = null,
    public val password: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val privateWhitelists: Output<List<String>>? = null,
    public val protocol: Output<String>? = null,
    public val publicWhitelists: Output<List<String>>? = null,
    public val renewStatus: Output<String>? = null,
    public val renewalDurationUnit: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val settingConfig: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val warmNodeAmount: Output<Int>? = null,
    public val warmNodeDiskEncrypted: Output<Boolean>? = null,
    public val warmNodeDiskSize: Output<Int>? = null,
    public val warmNodeDiskType: Output<String>? = null,
    public val warmNodeSpec: Output<String>? = null,
    public val zoneCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.elasticsearch.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.elasticsearch.InstanceArgs =
        com.pulumi.alicloud.elasticsearch.InstanceArgs.builder()
            .autoRenewDuration(autoRenewDuration?.applyValue({ args0 -> args0 }))
            .clientNodeAmount(clientNodeAmount?.applyValue({ args0 -> args0 }))
            .clientNodeSpec(clientNodeSpec?.applyValue({ args0 -> args0 }))
            .dataNodeAmount(dataNodeAmount?.applyValue({ args0 -> args0 }))
            .dataNodeDiskEncrypted(dataNodeDiskEncrypted?.applyValue({ args0 -> args0 }))
            .dataNodeDiskPerformanceLevel(dataNodeDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .dataNodeDiskSize(dataNodeDiskSize?.applyValue({ args0 -> args0 }))
            .dataNodeDiskType(dataNodeDiskType?.applyValue({ args0 -> args0 }))
            .dataNodeSpec(dataNodeSpec?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableKibanaPrivateNetwork(enableKibanaPrivateNetwork?.applyValue({ args0 -> args0 }))
            .enableKibanaPublicNetwork(enableKibanaPublicNetwork?.applyValue({ args0 -> args0 }))
            .enablePublic(enablePublic?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .kibanaNodeSpec(kibanaNodeSpec?.applyValue({ args0 -> args0 }))
            .kibanaPrivateSecurityGroupId(kibanaPrivateSecurityGroupId?.applyValue({ args0 -> args0 }))
            .kibanaPrivateWhitelists(
                kibanaPrivateWhitelists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .kibanaWhitelists(kibanaWhitelists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .masterNodeDiskType(masterNodeDiskType?.applyValue({ args0 -> args0 }))
            .masterNodeSpec(masterNodeSpec?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .privateWhitelists(privateWhitelists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .publicWhitelists(publicWhitelists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .renewStatus(renewStatus?.applyValue({ args0 -> args0 }))
            .renewalDurationUnit(renewalDurationUnit?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .settingConfig(
                settingConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .warmNodeAmount(warmNodeAmount?.applyValue({ args0 -> args0 }))
            .warmNodeDiskEncrypted(warmNodeDiskEncrypted?.applyValue({ args0 -> args0 }))
            .warmNodeDiskSize(warmNodeDiskSize?.applyValue({ args0 -> args0 }))
            .warmNodeDiskType(warmNodeDiskType?.applyValue({ args0 -> args0 }))
            .warmNodeSpec(warmNodeSpec?.applyValue({ args0 -> args0 }))
            .zoneCount(zoneCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoRenewDuration: Output<Int>? = null

    private var clientNodeAmount: Output<Int>? = null

    private var clientNodeSpec: Output<String>? = null

    private var dataNodeAmount: Output<Int>? = null

    private var dataNodeDiskEncrypted: Output<Boolean>? = null

    private var dataNodeDiskPerformanceLevel: Output<String>? = null

    private var dataNodeDiskSize: Output<Int>? = null

    private var dataNodeDiskType: Output<String>? = null

    private var dataNodeSpec: Output<String>? = null

    private var description: Output<String>? = null

    private var enableKibanaPrivateNetwork: Output<Boolean>? = null

    private var enableKibanaPublicNetwork: Output<Boolean>? = null

    private var enablePublic: Output<Boolean>? = null

    private var instanceChargeType: Output<String>? = null

    private var kibanaNodeSpec: Output<String>? = null

    private var kibanaPrivateSecurityGroupId: Output<String>? = null

    private var kibanaPrivateWhitelists: Output<List<String>>? = null

    private var kibanaWhitelists: Output<List<String>>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var masterNodeDiskType: Output<String>? = null

    private var masterNodeSpec: Output<String>? = null

    private var password: Output<String>? = null

    private var period: Output<Int>? = null

    private var privateWhitelists: Output<List<String>>? = null

    private var protocol: Output<String>? = null

    private var publicWhitelists: Output<List<String>>? = null

    private var renewStatus: Output<String>? = null

    private var renewalDurationUnit: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var settingConfig: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var warmNodeAmount: Output<Int>? = null

    private var warmNodeDiskEncrypted: Output<Boolean>? = null

    private var warmNodeDiskSize: Output<Int>? = null

    private var warmNodeDiskType: Output<String>? = null

    private var warmNodeSpec: Output<String>? = null

    private var zoneCount: Output<Int>? = null

    /**
     * @param value Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
     */
    @JvmName("gmebujgelwsbxpqh")
    public suspend fun autoRenewDuration(`value`: Output<Int>) {
        this.autoRenewDuration = value
    }

    /**
     * @param value The Elasticsearch cluster's client node quantity, between 2 and 25.
     */
    @JvmName("mhlgyblmrxqlthin")
    public suspend fun clientNodeAmount(`value`: Output<Int>) {
        this.clientNodeAmount = value
    }

    /**
     * @param value The client node spec. If specified, client node will be created.
     */
    @JvmName("ocajspqqmfieefjy")
    public suspend fun clientNodeSpec(`value`: Output<String>) {
        this.clientNodeSpec = value
    }

    /**
     * @param value The Elasticsearch cluster's data node quantity, between 2 and 50.
     */
    @JvmName("tqmeyyitxqaqwiat")
    public suspend fun dataNodeAmount(`value`: Output<Int>) {
        this.dataNodeAmount = value
    }

    /**
     * @param value If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
     */
    @JvmName("fbotenfwsrdudfrl")
    public suspend fun dataNodeDiskEncrypted(`value`: Output<Boolean>) {
        this.dataNodeDiskEncrypted = value
    }

    /**
     * @param value Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
     */
    @JvmName("dqkpsclfvxioljtv")
    public suspend fun dataNodeDiskPerformanceLevel(`value`: Output<String>) {
        this.dataNodeDiskPerformanceLevel = value
    }

    /**
     * @param value The single data node storage space.
     */
    @JvmName("opxspljeimvqwgqn")
    public suspend fun dataNodeDiskSize(`value`: Output<Int>) {
        this.dataNodeDiskSize = value
    }

    /**
     * @param value The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
     */
    @JvmName("ljbuvobeagwdqfpq")
    public suspend fun dataNodeDiskType(`value`: Output<String>) {
        this.dataNodeDiskType = value
    }

    /**
     * @param value The data node specifications of the Elasticsearch instance.
     */
    @JvmName("dehqxojgmsksrryu")
    public suspend fun dataNodeSpec(`value`: Output<String>) {
        this.dataNodeSpec = value
    }

    /**
     * @param value The description of instance. It a string of 0 to 30 characters.
     */
    @JvmName("lcmdfgalomxihrxy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Bool, default to false. When it set to true, the instance can close kibana private network access。
     */
    @JvmName("ndofnhoqemwltqam")
    public suspend fun enableKibanaPrivateNetwork(`value`: Output<Boolean>) {
        this.enableKibanaPrivateNetwork = value
    }

    /**
     * @param value Bool, default to true. When it set to false, the instance can enable kibana public network access。
     */
    @JvmName("wvxnkkappcdaxjmu")
    public suspend fun enableKibanaPublicNetwork(`value`: Output<Boolean>) {
        this.enableKibanaPublicNetwork = value
    }

    /**
     * @param value Bool, default to false. When it set to true, the instance can enable public network access。
     */
    @JvmName("dwmhenmavrtewicl")
    public suspend fun enablePublic(`value`: Output<Boolean>) {
        this.enablePublic = value
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
     */
    @JvmName("esxnvoqrfbawrjwd")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
     */
    @JvmName("hvcoevibfvxkgrbl")
    public suspend fun kibanaNodeSpec(`value`: Output<String>) {
        this.kibanaNodeSpec = value
    }

    /**
     * @param value the security group id associated with Kibana private network, this param is required when `enable_kibana_private_network` set true, and the security group id should in the same VPC as `vswitch_id`
     */
    @JvmName("ufpkykcbwaoxxsxc")
    public suspend fun kibanaPrivateSecurityGroupId(`value`: Output<String>) {
        this.kibanaPrivateSecurityGroupId = value
    }

    /**
     * @param value Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
     */
    @JvmName("xojfwdskcrgdicxy")
    public suspend fun kibanaPrivateWhitelists(`value`: Output<List<String>>) {
        this.kibanaPrivateWhitelists = value
    }

    @JvmName("oubhgvwtlhysrlxx")
    public suspend fun kibanaPrivateWhitelists(vararg values: Output<String>) {
        this.kibanaPrivateWhitelists = Output.all(values.asList())
    }

    /**
     * @param values Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
     */
    @JvmName("rqgvichsufdelkpk")
    public suspend fun kibanaPrivateWhitelists(values: List<Output<String>>) {
        this.kibanaPrivateWhitelists = Output.all(values)
    }

    /**
     * @param value Set the Kibana's IP whitelist in internet network.
     */
    @JvmName("msqsiutvmtnbyian")
    public suspend fun kibanaWhitelists(`value`: Output<List<String>>) {
        this.kibanaWhitelists = value
    }

    @JvmName("fyqlgyxiadvjnwoi")
    public suspend fun kibanaWhitelists(vararg values: Output<String>) {
        this.kibanaWhitelists = Output.all(values.asList())
    }

    /**
     * @param values Set the Kibana's IP whitelist in internet network.
     */
    @JvmName("ulqpdildeagwubls")
    public suspend fun kibanaWhitelists(values: List<Output<String>>) {
        this.kibanaWhitelists = Output.all(values)
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
     */
    @JvmName("cslqsfcabyvwhyux")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("xdiglybfbrghugmi")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
     */
    @JvmName("oikqujduwygysxvp")
    public suspend fun masterNodeDiskType(`value`: Output<String>) {
        this.masterNodeDiskType = value
    }

    /**
     * @param value The dedicated master node spec. If specified, dedicated master node will be created.
     */
    @JvmName("etgmptuquhnaniux")
    public suspend fun masterNodeSpec(`value`: Output<String>) {
        this.masterNodeSpec = value
    }

    /**
     * @param value The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
     */
    @JvmName("jubxmcdcwswrtyqw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
     */
    @JvmName("kqwxttkvpskkflbm")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Set the instance's IP whitelist in VPC network.
     */
    @JvmName("idwpjyhgjtkaqebe")
    public suspend fun privateWhitelists(`value`: Output<List<String>>) {
        this.privateWhitelists = value
    }

    @JvmName("yqejxpvdmhauoauq")
    public suspend fun privateWhitelists(vararg values: Output<String>) {
        this.privateWhitelists = Output.all(values.asList())
    }

    /**
     * @param values Set the instance's IP whitelist in VPC network.
     */
    @JvmName("rrnolnquocslgekl")
    public suspend fun privateWhitelists(values: List<Output<String>>) {
        this.privateWhitelists = Output.all(values)
    }

    /**
     * @param value Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
     */
    @JvmName("hkvhprxcrbsjtolw")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Set the instance's IP whitelist in internet network.
     */
    @JvmName("fysokypuqdohxnui")
    public suspend fun publicWhitelists(`value`: Output<List<String>>) {
        this.publicWhitelists = value
    }

    @JvmName("rkpiobxlqlcagdoi")
    public suspend fun publicWhitelists(vararg values: Output<String>) {
        this.publicWhitelists = Output.all(values.asList())
    }

    /**
     * @param values Set the instance's IP whitelist in internet network.
     */
    @JvmName("kphxhcgtgqbnpxge")
    public suspend fun publicWhitelists(values: List<Output<String>>) {
        this.publicWhitelists = Output.all(values)
    }

    /**
     * @param value The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
     */
    @JvmName("kloqwsivoqfnrycq")
    public suspend fun renewStatus(`value`: Output<String>) {
        this.renewStatus = value
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
     */
    @JvmName("tskqpxivbnrjpoui")
    public suspend fun renewalDurationUnit(`value`: Output<String>) {
        this.renewalDurationUnit = value
    }

    /**
     * @param value The ID of resource group which the Elasticsearch instance belongs.
     */
    @JvmName("jfxevketjvchoctt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
     */
    @JvmName("mdtxhgstfeehmpjo")
    public suspend fun settingConfig(`value`: Output<Map<String, String>>) {
        this.settingConfig = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ogaijmlkdfmeifqt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` , `7.7_with_X-Pack`, `7.10_with_X-Pack`, `7.16_with_X-Pack`, `8.5_with_X-Pack`, `8.9_with_X-Pack`, `8.13_with_X-Pack`.
     */
    @JvmName("jtipkvwglufvjtla")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The ID of VSwitch.
     */
    @JvmName("aqjouvixlipiuooh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Elasticsearch cluster's warm node quantity, between 3 and 50.
     */
    @JvmName("modnffpxykqeoebc")
    public suspend fun warmNodeAmount(`value`: Output<Int>) {
        this.warmNodeAmount = value
    }

    /**
     * @param value If encrypt the warm node disk. Valid values are `true`, `false`. Default to `false`.
     */
    @JvmName("whpuvqdpqcrxauqy")
    public suspend fun warmNodeDiskEncrypted(`value`: Output<Boolean>) {
        this.warmNodeDiskEncrypted = value
    }

    /**
     * @param value The single warm node storage space, should between 500 and 20480
     */
    @JvmName("ulcairoaqyrfvrsp")
    public suspend fun warmNodeDiskSize(`value`: Output<Int>) {
        this.warmNodeDiskSize = value
    }

    /**
     * @param value The warm node disk type. Supported values:  cloud_efficiency.
     */
    @JvmName("yjlfwldyiparwipd")
    public suspend fun warmNodeDiskType(`value`: Output<String>) {
        this.warmNodeDiskType = value
    }

    /**
     * @param value The warm node specifications of the Elasticsearch instance.
     */
    @JvmName("dwjwqsfsippbptpk")
    public suspend fun warmNodeSpec(`value`: Output<String>) {
        this.warmNodeSpec = value
    }

    /**
     * @param value The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
     */
    @JvmName("evoxaitqoasdvgik")
    public suspend fun zoneCount(`value`: Output<Int>) {
        this.zoneCount = value
    }

    /**
     * @param value Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
     */
    @JvmName("lodkrbmjpklspxbx")
    public suspend fun autoRenewDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDuration = mapped
    }

    /**
     * @param value The Elasticsearch cluster's client node quantity, between 2 and 25.
     */
    @JvmName("mtqhtunhosqersds")
    public suspend fun clientNodeAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientNodeAmount = mapped
    }

    /**
     * @param value The client node spec. If specified, client node will be created.
     */
    @JvmName("ocikqenrsqenifph")
    public suspend fun clientNodeSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientNodeSpec = mapped
    }

    /**
     * @param value The Elasticsearch cluster's data node quantity, between 2 and 50.
     */
    @JvmName("lnmhftawrkrxmsgk")
    public suspend fun dataNodeAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeAmount = mapped
    }

    /**
     * @param value If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
     */
    @JvmName("rrmcgwoqynimhcel")
    public suspend fun dataNodeDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeDiskEncrypted = mapped
    }

    /**
     * @param value Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
     */
    @JvmName("acfgbfvaienqamxi")
    public suspend fun dataNodeDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeDiskPerformanceLevel = mapped
    }

    /**
     * @param value The single data node storage space.
     */
    @JvmName("cntcktskocmlwfme")
    public suspend fun dataNodeDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeDiskSize = mapped
    }

    /**
     * @param value The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
     */
    @JvmName("lgyqcwddbtdihnwk")
    public suspend fun dataNodeDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeDiskType = mapped
    }

    /**
     * @param value The data node specifications of the Elasticsearch instance.
     */
    @JvmName("uwqrsbjejbjyidne")
    public suspend fun dataNodeSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNodeSpec = mapped
    }

    /**
     * @param value The description of instance. It a string of 0 to 30 characters.
     */
    @JvmName("mmadotqbpviyfhpy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Bool, default to false. When it set to true, the instance can close kibana private network access。
     */
    @JvmName("xcyfpdbwosfmoasu")
    public suspend fun enableKibanaPrivateNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableKibanaPrivateNetwork = mapped
    }

    /**
     * @param value Bool, default to true. When it set to false, the instance can enable kibana public network access。
     */
    @JvmName("gtlyuthqeemutanc")
    public suspend fun enableKibanaPublicNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableKibanaPublicNetwork = mapped
    }

    /**
     * @param value Bool, default to false. When it set to true, the instance can enable public network access。
     */
    @JvmName("rwybyqapuhyxymgx")
    public suspend fun enablePublic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublic = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
     */
    @JvmName("vpaignjqqijpgxao")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
     */
    @JvmName("nrsnfnfmuitxmgsy")
    public suspend fun kibanaNodeSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kibanaNodeSpec = mapped
    }

    /**
     * @param value the security group id associated with Kibana private network, this param is required when `enable_kibana_private_network` set true, and the security group id should in the same VPC as `vswitch_id`
     */
    @JvmName("athtmjoucgtbclpa")
    public suspend fun kibanaPrivateSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kibanaPrivateSecurityGroupId = mapped
    }

    /**
     * @param value Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
     */
    @JvmName("vrqmvpwtjvjksgpp")
    public suspend fun kibanaPrivateWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kibanaPrivateWhitelists = mapped
    }

    /**
     * @param values Set the Kibana's IP whitelist in private network, This option has been abandoned on newly created instance, please use `kibana_private_security_group_id` instead
     */
    @JvmName("xfogdbuiglxtxuag")
    public suspend fun kibanaPrivateWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kibanaPrivateWhitelists = mapped
    }

    /**
     * @param value Set the Kibana's IP whitelist in internet network.
     */
    @JvmName("tplmbjehfvthawsk")
    public suspend fun kibanaWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kibanaWhitelists = mapped
    }

    /**
     * @param values Set the Kibana's IP whitelist in internet network.
     */
    @JvmName("mrlyynohgdbetbvu")
    public suspend fun kibanaWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kibanaWhitelists = mapped
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
     */
    @JvmName("pxlywpkwltbjirws")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("aerakckcfcvsaamo")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("xfyskxmejqercvcb")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
     */
    @JvmName("eeccbeiwaymuavir")
    public suspend fun masterNodeDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterNodeDiskType = mapped
    }

    /**
     * @param value The dedicated master node spec. If specified, dedicated master node will be created.
     */
    @JvmName("ylgryuiqpxjlgobn")
    public suspend fun masterNodeSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterNodeSpec = mapped
    }

    /**
     * @param value The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
     */
    @JvmName("kdedidhmjncjbvlw")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
     */
    @JvmName("vhlwilhvhmehndft")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Set the instance's IP whitelist in VPC network.
     */
    @JvmName("qqncofesgsvnssmc")
    public suspend fun privateWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateWhitelists = mapped
    }

    /**
     * @param values Set the instance's IP whitelist in VPC network.
     */
    @JvmName("emaumatdwrsmeowq")
    public suspend fun privateWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateWhitelists = mapped
    }

    /**
     * @param value Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
     */
    @JvmName("xtmxyrgepqsakkwa")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Set the instance's IP whitelist in internet network.
     */
    @JvmName("msrdutashibhiyrw")
    public suspend fun publicWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicWhitelists = mapped
    }

    /**
     * @param values Set the instance's IP whitelist in internet network.
     */
    @JvmName("sbbutvefyttbphsy")
    public suspend fun publicWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicWhitelists = mapped
    }

    /**
     * @param value The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
     */
    @JvmName("uqrgkcogvrmdlppe")
    public suspend fun renewStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewStatus = mapped
    }

    /**
     * @param value Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
     */
    @JvmName("tbsvqgovjlladpux")
    public suspend fun renewalDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalDurationUnit = mapped
    }

    /**
     * @param value The ID of resource group which the Elasticsearch instance belongs.
     */
    @JvmName("hphnryfrtnindqmh")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
     */
    @JvmName("dhbtbkgilfiajsph")
    public suspend fun settingConfig(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingConfig = mapped
    }

    /**
     * @param values The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
     */
    @JvmName("kdpxlrcdbknoocqx")
    public fun settingConfig(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settingConfig = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pjrgeunsmtebtdsc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("gmbgmprydfshsffg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` , `7.7_with_X-Pack`, `7.10_with_X-Pack`, `7.16_with_X-Pack`, `8.5_with_X-Pack`, `8.9_with_X-Pack`, `8.13_with_X-Pack`.
     */
    @JvmName("rsternccmyfkfnjj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The ID of VSwitch.
     */
    @JvmName("bqrwqgjyyyaeaqwn")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Elasticsearch cluster's warm node quantity, between 3 and 50.
     */
    @JvmName("aaguvrjnbiqfnmah")
    public suspend fun warmNodeAmount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmNodeAmount = mapped
    }

    /**
     * @param value If encrypt the warm node disk. Valid values are `true`, `false`. Default to `false`.
     */
    @JvmName("xulpickvvnwvwewq")
    public suspend fun warmNodeDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmNodeDiskEncrypted = mapped
    }

    /**
     * @param value The single warm node storage space, should between 500 and 20480
     */
    @JvmName("letgfjcfeuiivknd")
    public suspend fun warmNodeDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmNodeDiskSize = mapped
    }

    /**
     * @param value The warm node disk type. Supported values:  cloud_efficiency.
     */
    @JvmName("ooqjpfotamyweysk")
    public suspend fun warmNodeDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmNodeDiskType = mapped
    }

    /**
     * @param value The warm node specifications of the Elasticsearch instance.
     */
    @JvmName("jtncegwtjyvmumrk")
    public suspend fun warmNodeSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmNodeSpec = mapped
    }

    /**
     * @param value The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
     */
    @JvmName("tclhckrytaqunnmj")
    public suspend fun zoneCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneCount = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoRenewDuration = autoRenewDuration,
        clientNodeAmount = clientNodeAmount,
        clientNodeSpec = clientNodeSpec,
        dataNodeAmount = dataNodeAmount,
        dataNodeDiskEncrypted = dataNodeDiskEncrypted,
        dataNodeDiskPerformanceLevel = dataNodeDiskPerformanceLevel,
        dataNodeDiskSize = dataNodeDiskSize,
        dataNodeDiskType = dataNodeDiskType,
        dataNodeSpec = dataNodeSpec,
        description = description,
        enableKibanaPrivateNetwork = enableKibanaPrivateNetwork,
        enableKibanaPublicNetwork = enableKibanaPublicNetwork,
        enablePublic = enablePublic,
        instanceChargeType = instanceChargeType,
        kibanaNodeSpec = kibanaNodeSpec,
        kibanaPrivateSecurityGroupId = kibanaPrivateSecurityGroupId,
        kibanaPrivateWhitelists = kibanaPrivateWhitelists,
        kibanaWhitelists = kibanaWhitelists,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        masterNodeDiskType = masterNodeDiskType,
        masterNodeSpec = masterNodeSpec,
        password = password,
        period = period,
        privateWhitelists = privateWhitelists,
        protocol = protocol,
        publicWhitelists = publicWhitelists,
        renewStatus = renewStatus,
        renewalDurationUnit = renewalDurationUnit,
        resourceGroupId = resourceGroupId,
        settingConfig = settingConfig,
        tags = tags,
        version = version,
        vswitchId = vswitchId,
        warmNodeAmount = warmNodeAmount,
        warmNodeDiskEncrypted = warmNodeDiskEncrypted,
        warmNodeDiskSize = warmNodeDiskSize,
        warmNodeDiskType = warmNodeDiskType,
        warmNodeSpec = warmNodeSpec,
        zoneCount = zoneCount,
    )
}
