@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.elasticsearch.kotlin.inputs

import com.pulumi.alicloud.elasticsearch.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property descriptionRegex
 * @property ids
 * @property outputFile
 * @property tags
 * @property version
 */
public data class GetInstancesPlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.elasticsearch.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.elasticsearch.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.elasticsearch.inputs.GetInstancesPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    private var version: String? = null

    /**
     * @param value
     */
    @JvmName("tpnioyfbvxxcmgwq")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("pyuwifyyqjldrfrj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("bgxectnbrlwodqdp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("vydeslooqldurqlv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ahuyevmchqffagsa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("prmfivyeqjbkwpub")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmgwvcwgsiexwlho")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        tags = tags,
        version = version,
    )
}
