@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.elasticsearch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property createdAt
 * @property dataNodeAmount
 * @property dataNodeDiskSize
 * @property dataNodeDiskType
 * @property dataNodeSpec
 * @property description
 * @property id
 * @property instanceChargeType
 * @property status
 * @property tags
 * @property updatedAt
 * @property version
 * @property vswitchId
 */
public data class GetInstancesInstance(
    public val createdAt: String,
    public val dataNodeAmount: Int,
    public val dataNodeDiskSize: Int,
    public val dataNodeDiskType: String,
    public val dataNodeSpec: String,
    public val description: String,
    public val id: String,
    public val instanceChargeType: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val updatedAt: String,
    public val version: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.elasticsearch.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            createdAt = javaType.createdAt(),
            dataNodeAmount = javaType.dataNodeAmount(),
            dataNodeDiskSize = javaType.dataNodeDiskSize(),
            dataNodeDiskType = javaType.dataNodeDiskType(),
            dataNodeSpec = javaType.dataNodeSpec(),
            description = javaType.description(),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updatedAt = javaType.updatedAt(),
            version = javaType.version(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
